/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.interFace.data.lock;

import com.arcway.lib.java.Assert;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRelationReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;

public abstract class AbstractCrossLinkRepositoryRelationLockSample
extends AbstractRepositoryLockSample {
    public abstract ICrossLinkRepositoryRelationReference getRelation();

    @Override
    public boolean isEqualTo(AbstractRepositoryLockSample sample) {
        if (this == sample) {
            return true;
        }
        if (sample == null) {
            return false;
        }
        if (!(sample instanceof AbstractCrossLinkRepositoryRelationLockSample)) {
            return false;
        }
        AbstractCrossLinkRepositoryRelationLockSample other = (AbstractCrossLinkRepositoryRelationLockSample)sample;
        assert (this.getRelation() != null);
        assert (other.getRelation() != null);
        if (ICrossLinkRepositoryRelationReference.REFERENCING_EQUAL_RELATIONS_HASHER.isEqual((Object)this.getRelation(), (Object)other.getRelation())) {
            if (this.getBasedSnapshotID() == null) {
                return other.getBasedSnapshotID() == null;
            }
            return RepositorySamples.isEqual(this.getBasedSnapshotID(), other.getBasedSnapshotID());
        }
        return false;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("RepositoryRelationLockSample: ");
        str.append("{relation=");
        str.append(this.getRelation());
        str.append(", based snapshot id=");
        str.append(this.getBasedSnapshotID());
        str.append('}');
        return str.toString();
    }

    @Override
    public boolean isCurrent(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
        ICrossLinkRepositoryRelation repositoryRelation;
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            repositoryRelation = RepositoryReferences.getRelationFromReference(this.getRelation(), snapshot);
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            return false;
        }
        catch (EXMissingCrossLinkTarget ex) {
            return false;
        }
        return RepositorySamples.isEqual(this.getBasedSnapshotID(), repositoryRelation.getSnapshotIDOfLastModification());
    }
}

