/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions.actions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.transactions.AbstractElementaryAction;
import com.arcway.repository.implementation.transactions.actions.LockHelper;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IParentRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import java.util.ArrayList;
import java.util.Arrays;

public class REAMoveObject
extends AbstractElementaryAction {
    private static final ILogger logger = Logger.getLogger(REAMoveObject.class);
    private IRepositoryObjectReference objectToMoveReference;
    private IRepositoryObjectReference newParentReference;
    private IRepositoryObject oldParent;

    public REAMoveObject(IRepositoryObjectReference objectToMove, IRepositoryObjectReference newParent) {
        this.objectToMoveReference = objectToMove;
        this.newParentReference = newParent;
    }

    @Override
    public void execute(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        assert (this.objectToMoveReference != null);
        assert (this.newParentReference != null);
        IRepositoryObjectType objectToMoveObjectType = snapshot.getTypeManager().getObjectType(this.objectToMoveReference.getObjectTypeID());
        IRepositoryObjectType newParentObjectType = snapshot.getTypeManager().getObjectType(this.newParentReference.getObjectTypeID());
        IRepositoryObject objectToMove = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)this.objectToMoveReference, (IRepositorySnapshotRO)snapshot);
        IRepositoryObject newParentObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)this.newParentReference, (IRepositorySnapshotRO)snapshot);
        IRepositoryAttributeSet oldParentAS = objectToMove.getParentAttributeSet();
        IRepositoryAttributeSet newParentAS = newParentObject.getParentAttributeSet();
        boolean isCompatibleParent = false;
        for (IParentRepositoryRelationContributionType parentRCType : objectToMoveObjectType.getParentRelationContributionTypesToParentObjectTypes()) {
            if (!parentRCType.getRelatedObjectType().isSuperTypeOf(newParentObjectType)) continue;
            isCompatibleParent = true;
            break;
        }
        if (!isCompatibleParent) {
            throw new RuntimeException("New parant not capable for the object type of object to move (new child).");
        }
        snapshot.moveObject(objectToMove, newParentObject);
        this.oldParent = objectToMove.getParentAttributeSet().getObject();
        try {
            ArrayList<AbstractRepositoryLockSample> locks = new ArrayList<AbstractRepositoryLockSample>();
            locks.addAll(Arrays.asList(LockHelper.lockNames(objectToMove)));
            locks.addAll(Arrays.asList(LockHelper.lockMovePath(objectToMove, oldParentAS, newParentAS)));
            this.setLocks(locks.toArray(new AbstractRepositoryLockSample[locks.size()]));
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error("Error getting locks for moving object", (Throwable)e);
            this.rollback(snapshot);
            throw e;
        }
    }

    @Override
    public void rollback(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        IRepositoryObject objectToMove;
        assert (this.objectToMoveReference != null);
        assert (this.oldParent != null);
        try {
            objectToMove = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)this.objectToMoveReference, (IRepositorySnapshotRO)snapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            throw new RuntimeException(e);
        }
        snapshot.moveObject(objectToMove, this.oldParent);
        this.oldParent = null;
    }

    public String getName() {
        return "Move Object Action";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        REAMoveObject clone = (REAMoveObject)((Object)super.clone());
        clone.objectToMoveReference = this.objectToMoveReference;
        clone.newParentReference = this.newParentReference;
        return clone;
    }
}

