/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.transactions.actions;

import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.implementation.transactions.AbstractElementaryAction;
import com.arcway.repository.implementation.transactions.actions.LockHelper;
import com.arcway.repository.interFace.data.RepositoryRelations;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRelationNotInstanciable;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.interFace.transactions.exceptions.EXRelationAlreadyExists;
import com.arcway.repository.interFace.transactions.exceptions.EXRelationTypeDoesNotExist;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationReference;

public class REACreateCrossLinkRelation
extends AbstractElementaryAction {
    private static final ILogger logger = Logger.getLogger(REACreateCrossLinkRelation.class);
    private ICrossLinkRepositoryRelationSample relationToCreate;

    public REACreateCrossLinkRelation(ICrossLinkRepositoryRelationSample relationToCreateSample) {
        this.relationToCreate = relationToCreateSample;
    }

    @Override
    public void execute(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXTransactionExecution, EXPermissionDenied, EXLockDenied {
        IRepositoryRelationTypeID relationTypeId;
        assert (this.relationToCreate != null);
        IRepositoryTypeManagerRO typeManagerRO = snapshot.getTypeManager();
        ICrossLinkRepositoryRelationType repositoryRelationType = typeManagerRO.findCrossLinkRelationType(relationTypeId = this.relationToCreate.getRelationTypeID());
        if (repositoryRelationType == null) {
            throw new EXRelationTypeDoesNotExist(relationTypeId);
        }
        if (!repositoryRelationType.canBeInstanciated()) {
            throw new EXCrossLinkRelationNotInstanciable(relationTypeId);
        }
        RepositorySamples.checkIfIsOfType((ICrossLinkRepositoryRelationSample)this.relationToCreate, (ICrossLinkRepositoryRelationType)repositoryRelationType);
        HashMap_ roleID2missingObjectIDs = new HashMap_(this.relationToCreate.getRelationContributionRoleIDs().size(), IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        for (IRepositoryRelationContributionRoleID roleID : this.relationToCreate.getRelationContributionRoleIDs()) {
            IRepositoryPropertySetSample objectId = this.relationToCreate.getObjectID(roleID);
            ICrossLinkRepositoryRelationContributionType rcType = repositoryRelationType.getRelationContributionType(roleID);
            IRepositoryObjectType objectType = rcType.getRelatedObjectType();
            IRepositoryObject relatedObject = snapshot.findRepositoryObject(objectType, objectId);
            if (relatedObject != null) continue;
            roleID2missingObjectIDs.put((Object)roleID, (Object)objectId);
        }
        if (!roleID2missingObjectIDs.isEmpty()) {
            throw new EXMissingCrossLinkTarget((ICrossLinkRepositoryRelationReference)new CrossLinkRepositoryRelationReference(this.relationToCreate), (IMap_)roleID2missingObjectIDs);
        }
        ICrossLinkRepositoryRelation relationAlreadyExist = RepositoryRelations.findCrossLinkRelation((ICrossLinkRepositoryRelationSample)this.relationToCreate, (IRepositorySnapshotRO)snapshot);
        if (relationAlreadyExist != null) {
            throw new EXRelationAlreadyExists(relationAlreadyExist.sample());
        }
        snapshot.createRelation(this.relationToCreate);
        try {
            this.setLocks(LockHelper.lockCrossLinkRelation(RepositoryRelations.findCrossLinkRelation((ICrossLinkRepositoryRelationSample)this.relationToCreate, (IRepositorySnapshotRO)snapshot)));
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error("Error getting locks for create relation", (Throwable)e);
            this.rollback(snapshot);
            throw e;
        }
    }

    @Override
    public void rollback(IRepositorySnapshotRW snapshot) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied, EXTransactionExecution {
        assert (this.relationToCreate != null);
        ICrossLinkRepositoryRelation createdRelation = RepositoryRelations.findCrossLinkRelation((ICrossLinkRepositoryRelationSample)this.relationToCreate, (IRepositorySnapshotRO)snapshot);
        assert (createdRelation != null);
        snapshot.deleteRelation(createdRelation);
    }

    public String getName() {
        return "Create New Relation Action";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        REACreateCrossLinkRelation clone = (REACreateCrossLinkRelation)((Object)super.clone());
        clone.relationToCreate = this.relationToCreate;
        return clone;
    }
}

