/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.type.relation;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.repository.implementation.registration.transaction.RegistrationTransaction;
import com.arcway.repository.implementation.registration.type.attributeset.RepositoryAttributeSetType;
import com.arcway.repository.implementation.registration.type.item.RepositoryItemType;
import com.arcway.repository.implementation.registration.type.manager.RepositoryTypeManager;
import com.arcway.repository.interFace.chassis.exceptions.EXMultipleIDUsage;
import com.arcway.repository.interFace.chassis.exceptions.EXRepositoryDeclarationInvalid;
import com.arcway.repository.interFace.declaration.data.item.IItemTypeID;
import com.arcway.repository.interFace.declaration.data.item.IItemUID;
import com.arcway.repository.interFace.declaration.data.key.KeySegment;
import com.arcway.repository.interFace.declaration.type.IRepositoryDeclarationItemID;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.item.IRepositoryItemTypeID;
import com.arcway.repository.interFace.declaration.type.relation.ICrossLinkRepositoryRelationTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IAbstractRepositoryRelationContributionTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IConcreteRepositoryRelationContributionTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionTypeDeclaration;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.attributeset.RepositoryAttributeSetTypeFinalizationType;
import com.arcway.repository.interFace.registration.type.relation.IAbstractRepositoryRelationType;
import com.arcway.repository.lib.high.declaration.data.item.ItemTypeID;
import com.arcway.repository.lib.high.declaration.type.RepositoryDeclarationItemTypeID;

public abstract class AbstractRepositoryRelationType
extends RepositoryItemType
implements IAbstractRepositoryRelationType {
    public static final ItemTypeID ITEM_TYPE_ID = new RepositoryDeclarationItemTypeID(new KeySegment("relationtype"));
    protected static final boolean IS_CONCRETE = true;
    protected static final boolean IS_ABSTRACT = false;
    private final IRepositoryRelationTypeID repositoryRelationTypeID;
    AbstractRepositoryRelationType abstractSuperRelationType = null;
    IMapRW_<IRepositoryRelationTypeID, AbstractRepositoryRelationType> directSubRelationTypes = new HashMap_(IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER);
    private ISetRW_<AbstractRepositoryRelationType> allInstanciableSubTypesCache;

    protected static void loadRelationType(RegistrationTransaction registrationTransaction, ICrossLinkRepositoryRelationTypeDeclaration relationTypeDeclaration, AbstractRepositoryRelationType newRelationType) throws EXRepositoryDeclarationInvalid {
        ICollection_ attributeSetDeclarations = relationTypeDeclaration.getAdditionalAttributeSetTypeDeclarations();
        RepositoryTypeManager.assertParameterIsNotNull(registrationTransaction, "attribute set declarations", attributeSetDeclarations);
        newRelationType.loadAttributeSetTypes(registrationTransaction, (ICollection_<IRepositoryAttributeSetTypeDeclaration>)attributeSetDeclarations);
    }

    protected static void assertThatAllRelationContributionsHaveDifferentIDs(RegistrationTransaction registrationTransaction, ICollection_<IAbstractRepositoryRelationContributionTypeDeclaration> abstractRepositoryRelationContributionTypeDeclarations, ICollection_<IConcreteRepositoryRelationContributionTypeDeclaration> concreteRepositoryRelationContributionTypeDeclarations) throws EXRepositoryDeclarationInvalid {
        HashSet_ allRoleIDs = new HashSet_(IItemTypeID.IS_EQUAL_ITEM_TYPE_ID_HASHER);
        AbstractRepositoryRelationType.assertThatCertainRelationContributionsHaveDifferentIDs(registrationTransaction, abstractRepositoryRelationContributionTypeDeclarations, (ISetRW_<IItemTypeID>)allRoleIDs);
        AbstractRepositoryRelationType.assertThatCertainRelationContributionsHaveDifferentIDs(registrationTransaction, concreteRepositoryRelationContributionTypeDeclarations, (ISetRW_<IItemTypeID>)allRoleIDs);
    }

    private static void assertThatCertainRelationContributionsHaveDifferentIDs(RegistrationTransaction registrationTransaction, ICollection_<? extends IRepositoryRelationContributionTypeDeclaration> repositoryRelationContributionTypeDeclarations, ISetRW_<IItemTypeID> allRoleIDs) throws EXRepositoryDeclarationInvalid {
        for (IRepositoryRelationContributionTypeDeclaration declaration : repositoryRelationContributionTypeDeclarations) {
            IRepositoryRelationContributionRoleID currentRoleID = declaration.getRelationContributionRoleID();
            IItemTypeID replacedID = (IItemTypeID)allRoleIDs.replace((Object)currentRoleID);
            if (replacedID == null) continue;
            throw new EXRepositoryDeclarationInvalid((IRepositoryDeclarationItemID)registrationTransaction.getModuleTypeID(), (Throwable)new EXMultipleIDUsage((IItemUID)replacedID));
        }
    }

    protected AbstractRepositoryRelationType(RepositoryTypeManager repositoryTypeManager, IRepositoryRelationTypeID repositoryRelationTypeID, boolean isConcrete) {
        super(repositoryTypeManager, !isConcrete, isConcrete);
        Assert.checkArgumentBeeingNotNull((Object)repositoryRelationTypeID);
        this.repositoryRelationTypeID = repositoryRelationTypeID;
    }

    public final IItemTypeID getItemTypeID() {
        return ITEM_TYPE_ID;
    }

    public final IRepositoryItemTypeID getRepositoryItemTypeID() {
        return this.getRepositoryRelationTypeID();
    }

    public final IRepositoryRelationTypeID getRepositoryRelationTypeID() {
        return this.repositoryRelationTypeID;
    }

    public final AbstractRepositoryRelationType getAbstractSuperRelationType() {
        return this.abstractSuperRelationType;
    }

    public ICollection_<? extends AbstractRepositoryRelationType> getDirectSubRelationTypes() {
        return this.directSubRelationTypes.values();
    }

    public synchronized ICollection_<? extends AbstractRepositoryRelationType> getAllInstanciableRelationTypesOfThisType() {
        if (this.allInstanciableSubTypesCache == null) {
            this.allInstanciableSubTypesCache = new HashSet_(IRepositoryDeclarationItem.EQUAL_ID_HASHER);
            this.addAllInstanciableSubtypes(this.allInstanciableSubTypesCache);
        }
        return this.allInstanciableSubTypesCache;
    }

    private void addAllInstanciableSubtypes(ISetRW_<AbstractRepositoryRelationType> allInstanciableSubTypes) {
        if (this.canBeInstanciated()) {
            allInstanciableSubTypes.add((Object)this);
        }
        for (AbstractRepositoryRelationType subRelationType : this.getDirectSubRelationTypes()) {
            subRelationType.addAllInstanciableSubtypes(allInstanciableSubTypes);
        }
    }

    public final boolean isSubTypeOf(IAbstractRepositoryRelationType superType) {
        return AbstractRepositoryRelationType.isInSuperSubTypeRelation(superType, this);
    }

    public final boolean isSuperTypeOf(IAbstractRepositoryRelationType subType) {
        return AbstractRepositoryRelationType.isInSuperSubTypeRelation(this, subType);
    }

    private static boolean isInSuperSubTypeRelation(IAbstractRepositoryRelationType superType, IAbstractRepositoryRelationType subType) {
        IAbstractRepositoryRelationType currentSuperType = subType;
        boolean isInSuperSubTypeRelation = false;
        while (!isInSuperSubTypeRelation && currentSuperType != null) {
            isInSuperSubTypeRelation |= currentSuperType == superType;
            currentSuperType = currentSuperType.getAbstractSuperRelationType();
        }
        return isInSuperSubTypeRelation;
    }

    private void loadAttributeSetTypes(RegistrationTransaction registrationTransaction, ICollection_<IRepositoryAttributeSetTypeDeclaration> attributeSetDeclarations) throws EXRepositoryDeclarationInvalid {
        for (IRepositoryAttributeSetTypeDeclaration declaration : attributeSetDeclarations) {
            this.loadAttributeSetType(registrationTransaction, declaration);
        }
    }

    public void loadAttributeSetType(RegistrationTransaction registrationTransaction, IRepositoryAttributeSetTypeDeclaration declaration) throws EXRepositoryDeclarationInvalid {
        RepositoryAttributeSetType.load(this, registrationTransaction, declaration, RepositoryAttributeSetTypeFinalizationType.IS_NOT_FINAL);
    }

    public void checkRelationContributionRoleIDIsUnused(RegistrationTransaction registrationTransaction, IRepositoryRelationContributionRoleID id) throws EXRepositoryDeclarationInvalid {
        RepositoryTypeManager.assertDeclarationItemIsNotFound(registrationTransaction, (IRepositoryDeclarationItemID)id, (IRepositoryDeclarationItem)this.findRelationContributionType(id));
    }
}

