/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.implementation.registration.transaction;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.repository.implementation.registration.transaction.IRegistrationAction;
import com.arcway.repository.implementation.registration.transaction.IUndoable;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;

public class RegistrationTransaction
implements IRegistrationAction {
    private final IRepositoryModuleTypeID moduleTypeID;
    private final RegistrationTransaction outerTransaction;
    private final IListRW_<IUndoable> actions = new ArrayList_();

    public RegistrationTransaction(IRepositoryModuleTypeID moduleTypeID) {
        Assert.checkArgumentBeeingNotNull((Object)moduleTypeID);
        this.moduleTypeID = moduleTypeID;
        this.outerTransaction = null;
    }

    public RegistrationTransaction(RegistrationTransaction outerTransaction) {
        Assert.checkArgumentBeeingNotNull((Object)outerTransaction);
        this.moduleTypeID = outerTransaction.getModuleTypeID();
        this.outerTransaction = outerTransaction;
    }

    public void execute(IRegistrationAction action) {
        Assert.checkArgumentBeeingNotNull((Object)action);
        action.dodo();
        this.actions.add((Object)action);
    }

    private void add(RegistrationTransaction registrationTransaction) {
        Assert.checkArgumentBeeingNotNull((Object)registrationTransaction);
        this.actions.add((Object)registrationTransaction);
    }

    public IRepositoryModuleTypeID getModuleTypeID() {
        return this.moduleTypeID;
    }

    public void commit() {
        if (this.outerTransaction != null) {
            this.outerTransaction.add(this);
        }
    }

    public void discard() {
        this.undo();
    }

    @Override
    public void dodo() {
    }

    @Override
    public void undo() {
        int i = this.actions.size() - 1;
        while (i >= 0) {
            ((IUndoable)this.actions.get(i)).undo();
            --i;
        }
    }
}

