/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.view;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planview.view.PVPlanViewPart;

public abstract class PVPlanObject
extends PVPlanViewPart {
    private Points points;

    public void setPoints(Points points) {
        this.points = points;
    }

    protected Points getPoints() {
        return this.points;
    }

    protected Polygon createPolygon(ILineAppearanceRO lineAppearance, boolean closedDraw) {
        Polygon polygon;
        if (lineAppearance != null && this.getPoints() != null) {
            double defaultCornerRadius = lineAppearance.getCornerRadius();
            boolean defaultCornerRadiusInfinity = lineAppearance.getCornerRadiusInfinity();
            Points points = this.getPoints();
            int pointCount = points.size();
            Corners corners = new Corners(pointCount);
            int pointIdx = 0;
            while (pointIdx < pointCount) {
                Point point = points.get(pointIdx);
                Corner corner = point instanceof Corner ? new Corner((Corner)point) : (defaultCornerRadiusInfinity ? new Corner(point) : new Corner(point, defaultCornerRadius));
                corners.add((Point)corner);
                ++pointIdx;
            }
            polygon = new Polygon(corners, closedDraw);
        } else {
            polygon = null;
        }
        return polygon;
    }
}

