/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planview.gui.view;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.gui.appearance.GUILineAndFillSupplementAppearance;
import com.arcway.planagent.planmodel.gui.appearance.IGUIAppearanceWithLineAndFillAppearanceRO;
import com.arcway.planagent.planview.view.PVGraphicalSupplement;

public class PVGraphicalSupplementGUIGroupGraphic
extends PVGraphicalSupplement {
    private GUILineAndFillSupplementAppearance symbolAppearance = new GUILineAndFillSupplementAppearance();
    private static final double CORNER_RADIUS = 1.0;
    private String text = null;
    private TextStyle textStyle = null;
    private double textHeight = 0.0;
    private Insets textInsets = null;

    public void setSymbolAppearance(GUILineAndFillSupplementAppearance appearance) {
        this.symbolAppearance = new GUILineAndFillSupplementAppearance((IGUIAppearanceWithLineAndFillAppearanceRO)appearance);
    }

    public void drawFigure(Device device) {
        assert (this.symbolAppearance != null) : "symbolAppearance is NULL";
        IFillAppearanceRO fillAppearance = this.symbolAppearance.getFillAppearanceRO();
        assert (fillAppearance != null) : "fillAppearance is null.";
        ILineAppearanceRO lineAppearance = this.symbolAppearance.getLineAppearanceRO();
        assert (lineAppearance != null) : "lineAppearance is null.";
        Color lineColor = lineAppearance.getLineColor();
        double thickness = lineAppearance.getLineThickness();
        LineStyle lineStyle = lineAppearance.getLineStyle();
        Rectangle bounds = this.getPoints().getBounds();
        assert (bounds != null) : "bounds is NULL.";
        Point upperLeft = bounds.upperLeft;
        Point lowerRight = bounds.lowerRight;
        double textWidth = 0.0;
        if (this.text != null && this.textStyle != null && this.textHeight != 0.0) {
            textWidth = device.getTextLength(this.text, this.textStyle, this.textHeight);
        }
        Corners corners = new Corners();
        corners.add((Point)new Corner(upperLeft.x + 2.5, upperLeft.y, 1.0));
        corners.add((Point)new Corner(upperLeft.x, upperLeft.y, 1.0));
        corners.add((Point)new Corner(upperLeft.x, lowerRight.y, 1.0));
        corners.add((Point)new Corner(lowerRight.x, lowerRight.y, 1.0));
        corners.add((Point)new Corner(lowerRight.x, upperLeft.y, 1.0));
        double space = 2.5 + textWidth + this.textInsets.leftInset + this.textInsets.rightInset;
        if (bounds.w() - space > 0.0) {
            corners.add((Point)new Corner(upperLeft.x + space, upperLeft.y, 1.0));
        }
        device.polyline(corners, thickness, lineColor, lineStyle);
    }

    public Rectangle getOuterBoundsWithoutChildren() {
        return this.getOuterBoundsWithoutChildrenByDrawing();
    }

    public void setTextForSpaceCalculation(String text, ITextAppearanceRO textAppearance) {
        this.text = text;
        if (textAppearance != null) {
            this.textStyle = textAppearance.getTextStyle();
            this.textHeight = textAppearance.getTextLineHeight();
            this.textInsets = textAppearance.getInsets();
        } else {
            this.textStyle = null;
            this.textHeight = 0.0;
            this.textInsets = new Insets(0.0);
        }
    }
}

