/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.routing;

import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Ray;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.routing.AbstractSetPointRouter;

public abstract class AbstractElongationToFigureRouter
extends AbstractSetPointRouter {
    public AbstractElongationToFigureRouter() {
        super(IAnchoringDestinationFigure.class);
    }

    public AbstractElongationToFigureRouter(Class<? extends IAnchoringDestination> destinationClassToCheck) {
        super(destinationClassToCheck);
    }

    @Override
    protected Point getTargetPosition(IAnchoringSourcePoint sourcePoint, IAnchoringDestination destination) {
        IAnchoringDestinationFigure destinationFigure = (IAnchoringDestinationFigure)destination;
        Point targetPoint = null;
        Point fromPoint = sourcePoint.getAnchoringSourceFromPoint().getAnchoringSourcePosition();
        Point toPointOld = this.getFigurePoint(sourcePoint, destinationFigure);
        Point fromPointForced = sourcePoint.getForce() == IAnchoringSourcePoint.FORCE_HORIZONTAL ? new Point(fromPoint.x, toPointOld.y) : (sourcePoint.getForce() == IAnchoringSourcePoint.FORCE_VERTICAL ? new Point(toPointOld.x, fromPoint.y) : fromPoint);
        Direction direction = new GeoVector(fromPointForced, toPointOld).getDirection();
        if (direction != null) {
            Polygon polygon = destinationFigure.getAnchoringDestinationPositionAsPolygon();
            if (polygon == null) {
                Corners corners = new Corners(destinationFigure.getAnchoringDestinationPosition(), 0.0);
                polygon = new Polygon(corners, destinationFigure.isAnchoringDestinationClosedDraw());
            }
            Ray interceptRay = new Ray(fromPointForced, direction);
            if (!polygon.hasBeenHit(fromPointForced, 0.0)) {
                Points points = interceptRay.getIntersectionPoints(polygon);
                targetPoint = points.getNearestPoint(fromPointForced);
            }
        }
        return targetPoint;
    }

    protected abstract Point getFigurePoint(IAnchoringSourcePoint var1, IAnchoringDestination var2);
}

