/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.reactions;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.FMCAPlanModelPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ReactionAgentRegistry {
    private static ReactionAgentRegistry singleton;
    private static ILogger logger;
    private final ArrayList<Object> reactionAgents = new ArrayList();

    static {
        logger = Logger.getLogger(ReactionAgentRegistry.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReactionAgentRegistry getInstance() {
        Class<ReactionAgentRegistry> clazz = ReactionAgentRegistry.class;
        synchronized (ReactionAgentRegistry.class) {
            if (singleton == null) {
                singleton = new ReactionAgentRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private ReactionAgentRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] reactionAgentExtensions = registry.getExtensionPoint(FMCAPlanModelPlugin.getPluginID(), "reactionagents").getExtensions();
        if (reactionAgentExtensions == null) {
            return;
        }
        IExtension[] iExtensionArray = reactionAgentExtensions;
        int n = reactionAgentExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension element = iExtensionArray[n2];
            IConfigurationElement[] configurationElements = element.getConfigurationElements();
            assert (configurationElements != null) : "invalid extension";
            IConfigurationElement[] iConfigurationElementArray = configurationElements;
            int n3 = configurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element2 = iConfigurationElementArray[n4];
                try {
                    Object reactionAgent = element2.createExecutableExtension("class");
                    this.registerReactionAgent(reactionAgent);
                }
                catch (CoreException e) {
                    logger.error("Could not create reaction agent.", (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void registerReactionAgent(Object agent) {
        assert (agent != null) : "attempt to register null";
        logger.debug(53, "Registering reaction agent: " + agent);
        this.reactionAgents.add(agent);
    }

    public List<Object> getAllReactionAgents() {
        return this.reactionAgents;
    }
}

