/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.reactions;

import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.DelayingActionIterator;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import com.arcway.planagent.planmodel.reactions.RouteAnchoringActionIterator;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.routing.RouterContext;
import java.util.List;
import java.util.ListIterator;

public class RAFixAnchoringsAfterNeighbourPointMoved
implements IRAChangeGeometryFigure {
    @Override
    public ActionIterator createReactionsFigureGeometryChanged(final IPMFigureRW figure, final List<PositionAndPoint> oldGeometry, final ActionContext actionContext) {
        return new DelayingActionIterator(){

            @Override
            protected ActionIterator createActionIterator() {
                return RAFixAnchoringsAfterNeighbourPointMoved.this.createReactionsFigureGeometryChangedDelayed(figure, oldGeometry, actionContext);
            }
        };
    }

    private ActionIterator createReactionsFigureGeometryChangedDelayed(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext actionContext) {
        ActionIterator reactionIterator = ActionIterator.EMPTY_ACTION_ITERATOR;
        RouterContext routingParameters = new RouterContext(null);
        IPMPointListRW newGeometry = figure.getPointListRW();
        ListIterator<PositionAndPoint> oldIterator = oldGeometry.listIterator();
        while (oldIterator.hasNext()) {
            PositionAndPoint currentOldPoint = oldIterator.next();
            int next = 0;
            while (next < newGeometry.getPointCount()) {
                IPMPointRW currentNewPoint = newGeometry.getPointRW(next);
                if (currentOldPoint.getPoint() == currentNewPoint && !currentNewPoint.getPosition().equalsPoint(currentOldPoint.getPosition())) {
                    if (next + 1 < newGeometry.getPointCount()) {
                        IPMPointRW rightNewNeighbourPoint = newGeometry.getPointRW(next + 1);
                        reactionIterator = this.addRouting(rightNewNeighbourPoint, actionContext, reactionIterator, routingParameters);
                    }
                    if (next - 1 >= 0) {
                        IPMPointRW leftNewNeighbourPoint = newGeometry.getPointRW(next - 1);
                        reactionIterator = this.addRouting(leftNewNeighbourPoint, actionContext, reactionIterator, routingParameters);
                    }
                }
                ++next;
            }
        }
        return reactionIterator;
    }

    private ActionIterator addRouting(IPMPointRW point, ActionContext actionContext, ActionIterator reactionIterator, IRoutingParameters routingParameters) {
        IPMAnchoringPointRW anchoring = point.getAnchoringRW();
        if (anchoring == null) {
            return reactionIterator;
        }
        RouteAnchoringActionIterator routeAnchoring = new RouteAnchoringActionIterator(anchoring, actionContext, routingParameters);
        return ActionIterator.concatenate(reactionIterator, routeAnchoring);
    }
}

