/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.persistent;

import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IFillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import de.plans.lib.xml.encoding.EAEncodableAttributes;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;

public class EAFillAppearance
extends EAEncodableAttributes
implements IFillAppearance {
    private static final String ATTR_TAG_FILLSTYLENAME = "stylename";
    private static final String ATTR_TAG_FILLCOLOR_FG_RED = "foreground.color.red";
    private static final String ATTR_TAG_FILLCOLOR_FG_GREEN = "foreground.color.green";
    private static final String ATTR_TAG_FILLCOLOR_FG_BLUE = "foreground.color.blue";
    private static final String ATTR_TAG_FILLCOLOR_FG_ALPHA = "foreground.color.alpha";
    private static final String ATTR_TAG_FILLCOLOR_BG_RED = "background.color.red";
    private static final String ATTR_TAG_FILLCOLOR_BG_GREEN = "background.color.green";
    private static final String ATTR_TAG_FILLCOLOR_BG_BLUE = "background.color.blue";
    private static final String ATTR_TAG_FILLCOLOR_BG_ALPHA = "background.color.alpha";
    private final FillStyle defaultFillStyle;
    private final String defaultFillStyleName;
    private final int defaultFillColorFgRed;
    private final int defaultFillColorFgGreen;
    private final int defaultFillColorFgBlue;
    private final int defaultFillColorFgAlpha;
    private final int defaultFillColorBgRed;
    private final int defaultFillColorBgGreen;
    private final int defaultFillColorBgBlue;
    private final int defaultFillColorBgAlpha;
    private FillStyle fillStyle;
    private String fillStyleName;
    private int fillColorFgRed;
    private int fillColorFgGreen;
    private int fillColorFgBlue;
    private int fillColorFgAlpha;
    private int fillColorBgRed;
    private int fillColorBgGreen;
    private int fillColorBgBlue;
    private int fillColorBgAlpha;

    public EAFillAppearance(String xmlAttrTag) {
        this(xmlAttrTag, DEFAULT_FILLSTYLE);
    }

    public EAFillAppearance(EAEncodableAttributes ea, String xmlAttrTag) {
        this(ea, xmlAttrTag, DEFAULT_FILLSTYLE);
    }

    public EAFillAppearance(String xmlAttrTag, FillStyle defaultFillStyle) {
        super(xmlAttrTag);
        this.defaultFillStyle = defaultFillStyle;
        this.defaultFillStyleName = this.defaultFillStyle.getName();
        this.defaultFillColorFgRed = 255;
        this.defaultFillColorFgGreen = 255;
        this.defaultFillColorFgBlue = 255;
        this.defaultFillColorFgAlpha = 255;
        this.defaultFillColorBgRed = 0;
        this.defaultFillColorBgGreen = 0;
        this.defaultFillColorBgBlue = 0;
        this.defaultFillColorBgAlpha = 0;
        this.setupAttributes();
    }

    public EAFillAppearance(EAEncodableAttributes ea, String xmlAttrTag, FillStyle defaultFillStyle) {
        super(ea, xmlAttrTag);
        this.defaultFillStyle = defaultFillStyle;
        this.defaultFillStyleName = this.defaultFillStyle.getName();
        this.defaultFillColorFgRed = 255;
        this.defaultFillColorFgGreen = 255;
        this.defaultFillColorFgBlue = 255;
        this.defaultFillColorFgAlpha = 255;
        this.defaultFillColorBgRed = 0;
        this.defaultFillColorBgGreen = 0;
        this.defaultFillColorBgBlue = 0;
        this.defaultFillColorBgAlpha = 0;
        this.setupAttributes();
    }

    private void setupAttributes() {
        this.fillStyle = this.defaultFillStyle;
        this.fillStyleName = this.defaultFillStyleName;
        this.fillColorFgRed = this.defaultFillColorFgRed;
        this.fillColorFgGreen = this.defaultFillColorFgGreen;
        this.fillColorFgBlue = this.defaultFillColorFgBlue;
        this.fillColorFgAlpha = this.defaultFillColorFgAlpha;
        this.fillColorBgRed = this.defaultFillColorBgRed;
        this.fillColorBgGreen = this.defaultFillColorBgGreen;
        this.fillColorBgBlue = this.defaultFillColorBgBlue;
        this.fillColorBgAlpha = this.defaultFillColorBgAlpha;
    }

    public void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (this.fillStyle != null) {
            if (!this.fillStyle.equals(this.defaultFillStyle)) {
                this.appendAttrToXML(writeContext, ATTR_TAG_FILLSTYLENAME, this.fillStyle.getName());
            }
        } else {
            this.appendAttrToXML(writeContext, ATTR_TAG_FILLSTYLENAME, this.fillStyleName);
        }
        if (this.fillColorFgRed != this.defaultFillColorFgRed || this.fillColorFgGreen != this.defaultFillColorFgGreen || this.fillColorFgBlue != this.defaultFillColorFgBlue) {
            this.appendAttrToXML(writeContext, ATTR_TAG_FILLCOLOR_FG_RED, this.fillColorFgRed);
            this.appendAttrToXML(writeContext, ATTR_TAG_FILLCOLOR_FG_GREEN, this.fillColorFgGreen);
            this.appendAttrToXML(writeContext, ATTR_TAG_FILLCOLOR_FG_BLUE, this.fillColorFgBlue);
        }
        if (this.fillColorFgAlpha != this.defaultFillColorFgAlpha) {
            this.appendAttrToXML(writeContext, ATTR_TAG_FILLCOLOR_FG_ALPHA, this.fillColorFgAlpha);
        }
        if (this.fillColorBgRed != this.defaultFillColorBgRed || this.fillColorBgGreen != this.defaultFillColorBgGreen || this.fillColorBgBlue != this.defaultFillColorBgBlue) {
            this.appendAttrToXML(writeContext, ATTR_TAG_FILLCOLOR_BG_RED, this.fillColorBgRed);
            this.appendAttrToXML(writeContext, ATTR_TAG_FILLCOLOR_BG_GREEN, this.fillColorBgGreen);
            this.appendAttrToXML(writeContext, ATTR_TAG_FILLCOLOR_BG_BLUE, this.fillColorBgBlue);
        }
        if (this.fillColorBgAlpha != this.defaultFillColorBgAlpha) {
            this.appendAttrToXML(writeContext, ATTR_TAG_FILLCOLOR_BG_ALPHA, this.fillColorBgAlpha);
        }
    }

    protected boolean setSubAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_FILLSTYLENAME)) {
            FillStyle style = FillStyle.fillStyleDefaultGetByName((String)value);
            if (style != null) {
                this.fillStyle = style;
                this.fillStyleName = style.getName();
            } else {
                this.fillStyle = this.defaultFillStyle;
                this.fillStyleName = value;
            }
        } else if (name.equals(ATTR_TAG_FILLCOLOR_FG_RED)) {
            this.fillColorFgRed = this.toInt(value);
        } else if (name.equals(ATTR_TAG_FILLCOLOR_FG_GREEN)) {
            this.fillColorFgGreen = this.toInt(value);
        } else if (name.equals(ATTR_TAG_FILLCOLOR_FG_BLUE)) {
            this.fillColorFgBlue = this.toInt(value);
        } else if (name.equals(ATTR_TAG_FILLCOLOR_FG_ALPHA)) {
            this.fillColorFgAlpha = this.toInt(value);
        } else if (name.equals(ATTR_TAG_FILLCOLOR_BG_RED)) {
            this.fillColorBgRed = this.toInt(value);
        } else if (name.equals(ATTR_TAG_FILLCOLOR_BG_GREEN)) {
            this.fillColorBgGreen = this.toInt(value);
        } else if (name.equals(ATTR_TAG_FILLCOLOR_BG_BLUE)) {
            this.fillColorBgBlue = this.toInt(value);
        } else if (name.equals(ATTR_TAG_FILLCOLOR_BG_ALPHA)) {
            this.fillColorBgAlpha = this.toInt(value);
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    @Override
    public FillColor getFillColor() {
        return new FillColor(this.fillColorFgRed, this.fillColorFgGreen, this.fillColorFgBlue, this.fillColorFgAlpha, this.fillColorBgRed, this.fillColorBgGreen, this.fillColorBgBlue, this.fillColorBgAlpha);
    }

    @Override
    public void setFillColor(FillColor fillColor) {
        assert (fillColor != null) : "fillColor is null";
        this.fillColorFgRed = fillColor.foregroundColor.r;
        this.fillColorFgGreen = fillColor.foregroundColor.g;
        this.fillColorFgBlue = fillColor.foregroundColor.b;
        this.fillColorFgAlpha = fillColor.foregroundAlpha;
        this.fillColorBgRed = fillColor.backgroundColor.r;
        this.fillColorBgGreen = fillColor.backgroundColor.g;
        this.fillColorBgBlue = fillColor.backgroundColor.b;
        this.fillColorBgAlpha = fillColor.backgroundAlpha;
    }

    @Override
    public void setFillStyle(FillStyle fillStyle) {
        assert (fillStyle != null) : "fillStyle  is null";
        this.fillStyle = fillStyle;
    }

    @Override
    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    @Override
    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof IFillAppearanceRO)) {
            return;
        }
        IFillAppearanceRO fill = (IFillAppearanceRO)appearance;
        this.setFillColor(fill.getFillColor());
        this.setFillStyle(fill.getFillStyle());
    }

    @Override
    public IAppearanceRO getAppearanceAsCopy() {
        return new FillAppearance(this);
    }
}

