/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import com.arcway.planagent.controllinginterface.planagent.IPlanElementRequestFlowInfo;
import com.arcway.planagent.controllinginterface.planagent.IPlanElementTextInfo;
import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMGraphicalSupplementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IRequestFlow;
import com.arcway.planagent.planmodel.access.readonly.IText;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.implementation.PlanElementModelWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StructuredPlanElementModelWrapper
extends PlanElementModelWrapper
implements IPlanAgentStructuredPlanElement {
    private final TopologyType topologyType;
    private final Rectangle outerBoundsInMM;
    private final Rectangle pointUnionInMM;
    private final Rectangle projectionAreaInMM;
    private final boolean isComment;
    private final Collection<? extends IPlanElementTextInfo> textInfos;
    private final Collection<? extends IPlanElementRequestFlowInfo> requestFlowInfos;
    private final ArrayList<StructuredPlanElementModelWrapper> containers = new ArrayList();
    private final ArrayList<StructuredPlanElementModelWrapper> contained = new ArrayList();
    private final ArrayList<StructuredPlanElementModelWrapper> writers = new ArrayList();
    private final ArrayList<StructuredPlanElementModelWrapper> readers = new ArrayList();
    private final ArrayList<StructuredPlanElementModelWrapper> successors = new ArrayList();
    private final ArrayList<StructuredPlanElementModelWrapper> predecessors = new ArrayList();

    private static final Collection<? extends IPlanElementTextInfo> getTextInfos(IPMPlanElementRO planElement) {
        ArrayList<IPlanElementTextInfo> textInfos = new ArrayList<IPlanElementTextInfo>();
        StructuredPlanElementModelWrapper.addTextInfos(planElement, textInfos);
        return textInfos;
    }

    private static final void addTextInfos(IPMPlanElementRO planElement, Collection<IPlanElementTextInfo> textInfos) {
        int i = 0;
        while (i < planElement.getFigureCount()) {
            StructuredPlanElementModelWrapper.addTextInfos(planElement.getFigureRO(i), textInfos);
            ++i;
        }
    }

    private static final void addTextInfos(IPMFigureRO figure, Collection<IPlanElementTextInfo> textInfos) {
        int i = 0;
        while (i < figure.getGraphicalSupplementCount()) {
            StructuredPlanElementModelWrapper.addTextInfos(figure.getGraphicalSupplementRO(i), textInfos);
            ++i;
        }
    }

    private static final void addTextInfos(IPMGraphicalSupplementRO graphicalSupplement, Collection<IPlanElementTextInfo> textInfos) {
        final String role = String.valueOf(graphicalSupplement.getFigureRO().getRole()) + '/' + graphicalSupplement.getRole();
        Collection<? extends IText> texts = graphicalSupplement.getTexts();
        for (IText iText : texts) {
            final String textContent = iText.getText();
            if (textContent.trim().length() <= 0) continue;
            final double height = iText.getTextLineHeight();
            textInfos.add(new IPlanElementTextInfo(){

                public String getRole() {
                    return role;
                }

                public String getText() {
                    return textContent;
                }

                public double getTextLineHeight() {
                    return height;
                }
            });
        }
    }

    private static final Collection<? extends IPlanElementRequestFlowInfo> getRequestFlowInfos(IPMPlanElementRO planElement) {
        ArrayList<IPlanElementRequestFlowInfo> requestFlowInfos = new ArrayList<IPlanElementRequestFlowInfo>();
        StructuredPlanElementModelWrapper.addRequestFlowInfos(planElement, requestFlowInfos);
        return requestFlowInfos;
    }

    private static final void addRequestFlowInfos(IPMPlanElementRO planElement, Collection<IPlanElementRequestFlowInfo> requestFlowInfos) {
        int i = 0;
        while (i < planElement.getFigureCount()) {
            StructuredPlanElementModelWrapper.addRequestFlowInfos(planElement.getFigureRO(i), requestFlowInfos);
            ++i;
        }
    }

    private static final void addRequestFlowInfos(IPMFigureRO figure, Collection<IPlanElementRequestFlowInfo> requestFlowInfos) {
        int i = 0;
        while (i < figure.getGraphicalSupplementCount()) {
            StructuredPlanElementModelWrapper.addRequestFlowInfos(figure.getGraphicalSupplementRO(i), requestFlowInfos);
            ++i;
        }
    }

    private static final void addRequestFlowInfos(IPMGraphicalSupplementRO graphicalSupplement, Collection<IPlanElementRequestFlowInfo> requestFlowInfos) {
        final String role = String.valueOf(graphicalSupplement.getFigureRO().getRole()) + '/' + graphicalSupplement.getRole();
        Collection<? extends IRequestFlow> requestFlows = graphicalSupplement.getRequestFlows();
        for (IRequestFlow iRequestFlow : requestFlows) {
            final Direction direction = iRequestFlow.getDirection();
            requestFlowInfos.add(new IPlanElementRequestFlowInfo(){

                public String getRole() {
                    return role;
                }

                public Direction getDirection() {
                    return direction;
                }
            });
        }
    }

    public StructuredPlanElementModelWrapper(IPMPlanElementRO planElement) {
        super(planElement);
        this.topologyType = planElement.getToplogyType();
        TransformationAffiliate planUnits2MM = TransformationAffiliate.newTransformationScaling((GeoVector)new GeoVector(1.0, 1.0));
        this.outerBoundsInMM = planElement.calculateOuterBounds().transform((Transformation)planUnits2MM);
        this.pointUnionInMM = planElement.calculatePointUnion().transform((Transformation)planUnits2MM);
        this.projectionAreaInMM = planElement.getProjectionArea().transform((Transformation)planUnits2MM);
        this.isComment = planElement.isComment();
        this.textInfos = StructuredPlanElementModelWrapper.getTextInfos(planElement);
        this.requestFlowInfos = StructuredPlanElementModelWrapper.getRequestFlowInfos(planElement);
    }

    public StructuredPlanElementModelWrapper(IPMPlanElementRW planElement) {
        super(planElement);
        this.topologyType = planElement.getToplogyType();
        TransformationAffiliate planUnits2MM = TransformationAffiliate.newTransformationScaling((GeoVector)new GeoVector(1.0, 1.0));
        this.outerBoundsInMM = planElement.calculateOuterBounds().transform((Transformation)planUnits2MM);
        this.pointUnionInMM = planElement.calculatePointUnion().transform((Transformation)planUnits2MM);
        this.projectionAreaInMM = planElement.getProjectionArea().transform((Transformation)planUnits2MM);
        this.isComment = planElement.isComment();
        this.textInfos = StructuredPlanElementModelWrapper.getTextInfos((IPMPlanElementRO)((Object)planElement));
        this.requestFlowInfos = StructuredPlanElementModelWrapper.getRequestFlowInfos((IPMPlanElementRO)((Object)planElement));
    }

    public TopologyType getToplogyType() {
        return this.topologyType;
    }

    public Rectangle getOuterBoundsInMM() {
        return this.outerBoundsInMM;
    }

    public Rectangle getPointUnionInMM() {
        return this.pointUnionInMM;
    }

    public Rectangle getProjectionAreaInMM() {
        return this.projectionAreaInMM;
    }

    public boolean isComment() {
        return this.isComment;
    }

    public Collection<? extends IPlanElementTextInfo> getTextInfos() {
        return this.textInfos;
    }

    public Collection<? extends IPlanElementRequestFlowInfo> getRequestFlowInfos() {
        return this.requestFlowInfos;
    }

    public List<? extends IPlanAgentStructuredPlanElement> getContainers() {
        return this.containers;
    }

    public List<? extends IPlanAgentStructuredPlanElement> getContainedPlanElements() {
        return this.contained;
    }

    public List<? extends IPlanAgentStructuredPlanElement> getPredecessors() {
        return this.predecessors;
    }

    public List<? extends IPlanAgentStructuredPlanElement> getSuccessors() {
        return this.successors;
    }

    public List<? extends IPlanAgentStructuredPlanElement> getReaders() {
        return this.readers;
    }

    public List<? extends IPlanAgentStructuredPlanElement> getWriters() {
        return this.writers;
    }

    public void reportContainedElement(StructuredPlanElementModelWrapper containedElement) {
        if (!this.contained.contains(containedElement)) {
            this.contained.add(containedElement);
            containedElement.reportContainer(this);
        }
    }

    private void reportContainer(StructuredPlanElementModelWrapper container) {
        this.containers.add(container);
    }

    public void reportReader(StructuredPlanElementModelWrapper readerWrapper) {
        if (!this.readers.contains(readerWrapper)) {
            this.readers.add(readerWrapper);
            readerWrapper.reportWriter(this);
        }
    }

    private void reportWriter(StructuredPlanElementModelWrapper writer) {
        this.writers.add(writer);
    }

    public void reportSuccessor(StructuredPlanElementModelWrapper successorWrapper) {
        if (!this.successors.contains(successorWrapper)) {
            this.successors.add(successorWrapper);
            successorWrapper.reportPredecessor(this);
        }
    }

    private void reportPredecessor(StructuredPlanElementModelWrapper predecessor) {
        this.predecessors.add(predecessor);
    }
}

