/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.implementation.IPlanModelObjectFactory;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.HashMap;
import java.util.List;

public class PlanModelObjectFactoryDispatcher {
    private static HashMap<Class<? extends EncodableObjectBase>, IPlanModelObjectFactory> factories = new HashMap(50, 0.5f);

    protected static void registerFactory(Class<? extends EOPlanModelObject> eoClass, IPlanModelObjectFactory factory) {
        factories.put(eoClass, factory);
    }

    private static IPlanModelObjectFactory getFactory(Class<? extends EncodableObjectBase> eoClass) {
        return factories.get(eoClass);
    }

    protected static PMPlanModelObject createPMObject(PlanModelMgr planModelMgr, EncodableObjectBase eo) throws EXPlanModelObjectFactoryException {
        PMPlanModelObject pm = null;
        IPlanModelObjectFactory factory = PlanModelObjectFactoryDispatcher.getFactory(eo.getClass());
        if (factory != null) {
            pm = factory.create(planModelMgr, eo);
            if (pm == null) {
                throw new EXPlanModelObjectFactoryException(factory + "created no object for object of type " + eo.getTag() + ".");
            }
        } else {
            throw new EXPlanModelObjectFactoryException("PM Factory not found for EO-Type " + eo.getClass().getName());
        }
        return pm;
    }

    protected static List<? extends EOEncodableObject> getChildren(EncodableObjectBase eo) throws EXPlanModelObjectFactoryException {
        assert (eo != null) : "eo is not null";
        IPlanModelObjectFactory factory = PlanModelObjectFactoryDispatcher.getFactory(eo.getClass());
        if (factory != null) {
            return factory.getChildren(eo);
        }
        throw new EXPlanModelObjectFactoryException("PM Factory not found for EO-Type " + eo.getClass().getName());
    }
}

