/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.implementation;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.PolygonCorner;
import com.arcway.lib.java.To;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMLineRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.implementation.IPMSemanticalUnit;
import com.arcway.planagent.planmodel.implementation.LoadPlanModelObjectList;
import com.arcway.planagent.planmodel.implementation.PMAnchor;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPoint;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToAnchor;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToFigure;
import com.arcway.planagent.planmodel.implementation.PMAnchoringPointToPoint;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMFigureDot;
import com.arcway.planagent.planmodel.implementation.PMFigureLineShape;
import com.arcway.planagent.planmodel.implementation.PMLine;
import com.arcway.planagent.planmodel.implementation.PMPlanElement;
import com.arcway.planagent.planmodel.implementation.PMPlanModelObject;
import com.arcway.planagent.planmodel.implementation.PMPlanObject;
import com.arcway.planagent.planmodel.implementation.PMPointList;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.implementation.PlanModelObjectFactoryDispatcher;
import com.arcway.planagent.planmodel.persistent.EOAnchoringPoint;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.EOPoint;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PMPoint
extends PMPlanModelObject
implements IPMPointRO,
IPMPointRW {
    private boolean polygonCornerCacheIsValid = false;
    private PolygonCorner polygonCornerCache = null;
    private boolean boundsCacheIsValid = false;
    private Rectangle boundsCache = null;
    private boolean positionCacheIsValid = false;
    private Point positionCache = null;
    private boolean positionCacheCornerRadiusInherited = true;
    private boolean positionCacheCornerRadiusInfinity = true;
    private double positionCacheCornerRadius = 0.0;
    private boolean realPositionCacheIsValid = false;
    private Point realPositionCache = null;
    private boolean widthCacheIsValid = false;
    private Double widthCache = null;
    private PMPointList pointList = null;
    private PMLine line1st = null;
    private PMLine line2nd = null;
    private PMAnchoringPoint anchoring = null;
    private final ArrayList<IAnchoring> pointToPointAnchorings = new ArrayList();
    private final EOPoint persistent;

    protected static void setupClass() {
        PlanModelObjectFactoryDispatcher.registerFactory(EOPoint.class, new PointFactory());
    }

    protected PMPoint(PlanModelMgr planModelMgr, EOPoint eo) {
        super(planModelMgr);
        this.persistent = eo;
    }

    protected EOPoint getPersistentPoint() {
        return this.persistent;
    }

    @Override
    protected EOPlanModelObject getPersistentPlanModelObject() {
        return this.getPersistentPoint();
    }

    protected PMPoint(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.persistent = new EOPoint();
    }

    @Override
    protected void linkToParent(PMPlanModelObject parent) {
        this.pointList = (PMPointList)parent;
    }

    @Override
    protected void linkToChild(PMPlanModelObject child) {
        if (child instanceof PMAnchoringPoint) {
            this.anchoring = (PMAnchoringPoint)child;
        }
    }

    @Override
    protected void linkCrossLinks(PMPlanModelObject root, LoadPlanModelObjectList objectList) {
    }

    @Override
    protected List<PMPlanModelObject> getChildren() {
        ArrayList<PMPlanModelObject> children = new ArrayList<PMPlanModelObject>(1);
        if (this.getAnchoring() != null) {
            children.add(this.getAnchoring());
        }
        return children;
    }

    protected void linkCrossLinkToLines(PMLine ln1st, PMLine ln2nd) {
        this.line1st = ln1st;
        this.line2nd = ln2nd;
    }

    protected void linkCrossLinkToPointToPointAnchoring(PMAnchoringPointToPoint anchrng) {
        assert (anchrng != null) : "anchoring is null";
        this.pointToPointAnchorings.add(anchrng);
    }

    @Override
    protected void setUID(String newUID) {
        super.setUID(newUID);
        for (IAnchoring iAnchoring : this.pointToPointAnchorings) {
            PMAnchoringPointToPoint anchoringPointToPoint = (PMAnchoringPointToPoint)iAnchoring;
            anchoringPointToPoint.setTargetPoint(this);
        }
    }

    public PMPointList getPointList() {
        return this.pointList;
    }

    @Override
    public IPMPointListRO getPointListRO() {
        return this.getPointList();
    }

    @Override
    public IPMPointListRW getPointListRW() {
        return this.getPointList();
    }

    public void setPointList(PMPointList pointList) {
        this.setPointList((Object)pointList);
    }

    @Override
    public void setPointList(IPMPointListRW pointList) {
        this.setPointList((Object)pointList);
    }

    private void setPointList(Object pointList) {
        assert (pointList == null || pointList instanceof PMPointList) : "list is not instanceof PMPointList";
        this.pointList = (PMPointList)pointList;
    }

    public PMLine getLine1st() {
        return this.line1st;
    }

    @Override
    public IPMLineRO getLine1stRO() {
        return this.getLine1st();
    }

    @Override
    public IPMLineRW getLine1stRW() {
        return this.getLine1st();
    }

    public void setLine1st(PMLine line) {
        this.setLine1st((Object)line);
    }

    @Override
    public void setLine1st(IPMLineRW line) {
        this.setLine1st((Object)line);
    }

    private void setLine1st(Object line) {
        assert (line == null || line instanceof PMLine) : "line is not instance of PMLine";
        this.line1st = (PMLine)line;
    }

    public PMLine getLine2nd() {
        return this.line2nd;
    }

    @Override
    public IPMLineRO getLine2ndRO() {
        return this.getLine2nd();
    }

    @Override
    public IPMLineRW getLine2ndRW() {
        return this.getLine2nd();
    }

    public void setLine2nd(PMLine line) {
        this.setLine2nd((Object)line);
    }

    @Override
    public void setLine2nd(IPMLineRW line) {
        this.setLine2nd((Object)line);
    }

    private void setLine2nd(Object line) {
        assert (line == null || line instanceof PMLine) : "line is not instance of PMLine";
        this.line2nd = (PMLine)line;
    }

    public PMAnchoringPoint getAnchoring() {
        return this.anchoring;
    }

    @Override
    public IPMAnchoringPointRO getAnchoringRO() {
        return this.getAnchoring();
    }

    @Override
    public IPMAnchoringPointRW getAnchoringRW() {
        return this.getAnchoring();
    }

    public void setAnchoring(PMAnchoringPoint anchoring) {
        this.setAnchoring((Object)anchoring);
    }

    @Override
    public void setAnchoring(IPMAnchoringPointRW anchoring) {
        this.setAnchoring((Object)anchoring);
    }

    private void setAnchoring(Object anchoring) {
        PMAnchoringPoint pMAnchoring;
        assert (anchoring == null || anchoring instanceof PMAnchoringPoint) : "anchoring is not instance of PMAnchoringPoint";
        this.anchoring = pMAnchoring = (PMAnchoringPoint)anchoring;
        EOAnchoringPoint eoanchoring = pMAnchoring == null ? null : pMAnchoring.getPersistentAnchoringPoint();
        this.getPersistentPoint().setAnchoring(eoanchoring);
    }

    @Override
    public int getPointToPointAnchoringCount() {
        return this.pointToPointAnchorings.size();
    }

    public int getAnchoringIndex(PMAnchoringPointToPoint anchrng) {
        return this.getPointToPointAnchoringIndex((Object)anchrng);
    }

    @Override
    public int getPointToPointAnchoringIndex(IPMAnchoringPointToPointRO anchrng) {
        return this.getPointToPointAnchoringIndex((Object)anchrng);
    }

    @Override
    public int getPointToPointAnchoringIndex(IPMAnchoringPointToPointRW anchrng) {
        return this.getPointToPointAnchoringIndex((Object)anchrng);
    }

    private int getPointToPointAnchoringIndex(Object anchrng) {
        assert (anchrng != null) : "anchoring is null";
        assert (anchrng instanceof PMAnchoringPointToPoint) : "anchoring is not instance of PMAnchoringPointToPoint";
        return this.pointToPointAnchorings.indexOf(anchrng);
    }

    public PMAnchoringPointToPoint getPointToPointAnchoring(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.getPointToPointAnchoringCount()) : "index >= getPointToPointAnchoringCount()";
        return (PMAnchoringPointToPoint)this.pointToPointAnchorings.get(index);
    }

    @Override
    public IPMAnchoringPointToPointRO getPointToPointAnchoringRO(int index) {
        return this.getPointToPointAnchoring(index);
    }

    @Override
    public IPMAnchoringPointToPointRW getPointToPointAnchoringRW(int index) {
        return this.getPointToPointAnchoring(index);
    }

    public void addPointToPointAnchoring(PMAnchoringPointToPoint anchrng, int i) {
        this.addPointToPointAnchoring((Object)anchrng, i);
    }

    @Override
    public void addPointToPointAnchoring(IPMAnchoringPointToPointRW anchrng, int i) {
        this.addPointToPointAnchoring((Object)anchrng, i);
    }

    private void addPointToPointAnchoring(Object anchrng, int i) {
        assert (anchrng != null) : "anchoring is null";
        assert (anchrng instanceof PMAnchoringPointToPoint) : "anchoring is not instance of PMAnchoringPointToPoint";
        assert (i >= 0 && i <= this.getPointToPointAnchoringCount()) : "i is out of bounds";
        this.pointToPointAnchorings.add(i, (IAnchoring)anchrng);
    }

    @Override
    public void removePointToPointAnchoring(int i) {
        assert (i >= 0) : "i<0";
        assert (i < this.getPointToPointAnchoringCount()) : "i >= getPointToPointAnchoringCount()";
        this.pointToPointAnchorings.remove(i);
    }

    public PMPlanObject getPlanObject() {
        PMPlanObject planObject = null;
        PMPointList pointLst = this.getPointList();
        if (pointLst != null) {
            planObject = this.getPointList().getPlanObject();
        }
        return planObject;
    }

    @Override
    public IPMPlanObjectRO getPlanObjectRO() {
        return this.getPlanObject();
    }

    @Override
    public IPMPlanObjectRW getPlanObjectRW() {
        return this.getPlanObject();
    }

    public PMPlanElement getPlanElement() {
        return this.getPointList().getPlanElement();
    }

    @Override
    public IPMPlanElementRO getPlanElementRO() {
        return this.getPlanElement();
    }

    @Override
    public IPMPlanElementRW getPlanElementRW() {
        return this.getPlanElement();
    }

    protected PMPoint(PlanModelMgr planModelMgr, PMPointList pointList) {
        super(planModelMgr);
        this.persistent = new EOPoint();
        this.setPointList(pointList);
    }

    protected void deleteAllChildren() {
        this.deleteAnchoring();
    }

    private void deleteAnchoring() {
        if (this.getAnchoring() != null) {
            this.getAnchoring().delete();
        }
    }

    protected void removeLinks() {
        this.setAnchoring(null);
        this.setLine1st(null);
        this.setLine1st(null);
        this.setPointList(null);
    }

    protected void move(GeoVector v) {
        assert (v != null) : "v = null";
        Point p = this.getPosition();
        p = p.movePoint(v);
        this.setPosition(p);
    }

    public PMAnchoringPointToFigure createAnchoring(PMFigure figure) {
        assert (figure != null) : "figure is null";
        this.deleteAnchoring();
        PMAnchoringPointToFigure anchoringPointToFigure = new PMAnchoringPointToFigure(this.getPlanModelMgr(), this, figure);
        figure.addAnchoring(anchoringPointToFigure, figure.getAnchoringCount());
        this.setAnchoring(anchoringPointToFigure);
        return anchoringPointToFigure;
    }

    public PMAnchoringPointToAnchor createAnchoring(PMAnchor anchor) {
        assert (anchor != null) : "anchor is null";
        this.deleteAnchoring();
        PMAnchoringPointToAnchor anchoringPointToAnchor = new PMAnchoringPointToAnchor(this.getPlanModelMgr(), this, anchor);
        this.setAnchoring(anchoringPointToAnchor);
        return anchoringPointToAnchor;
    }

    public PMAnchoringPointToPoint createAnchoring(PMPoint point2nd) {
        assert (point2nd != null) : "point2nd is null";
        this.deleteAnchoring();
        point2nd.deleteAnchoring();
        PMAnchoringPointToPoint anchoringPointToPoint = new PMAnchoringPointToPoint(this.getPlanModelMgr(), this, point2nd);
        this.setAnchoring(anchoringPointToPoint);
        return anchoringPointToPoint;
    }

    public void delete() {
        if (this.getLine1st() == null && this.getLine2nd() == null) {
            this.deleteAllChildren();
            this.removeLinks();
            this.getPointList().removePoint(this.getPointList().getPointIndex(this));
        } else if (this.getLine1st() != null && this.getLine2nd() != null) {
            if (this.getLine1st().getForce() == 2 && this.getLine2nd().getForce() == 3 && this.getLine1st().getForce() == 3 && this.getLine2nd().getForce() == 2) {
                this.getLine1st().swapWithNext();
                this.getLine1st().getPoint1st().getLine1st().joinWithNext();
                this.getLine2nd().joinWithNext();
            } else {
                this.getLine1st().joinWithNext();
            }
        } else if (this.getLine1st() != null) {
            this.getLine1st().delete();
        } else {
            this.getLine2nd().delete();
        }
    }

    @Override
    public IPMSemanticalUnit getSemanticalUnit() {
        return this.getPlanElement();
    }

    @Override
    public IPMFigureRO getAnchoringFigure() {
        return this.getPointList().getRelatedFigure();
    }

    @Override
    public IAnchoringSource getRootSource() {
        return this.getPlanElement().getRootSource(this);
    }

    @Override
    public Collection<IAnchoringSource> getChildSources() {
        return this.getPlanElement().getChildSources(this);
    }

    @Override
    public IAnchoringDestinationContributor getSourceRelatedDestinationContributor() {
        PMFigure relatedDestinations = null;
        PMPlanObject planObject = this.getPlanObject();
        if (planObject instanceof PMFigure) {
            PMFigure figure;
            relatedDestinations = figure = (PMFigure)planObject;
        }
        return relatedDestinations;
    }

    @Override
    public IAnchoring getIAnchoring() {
        return this.anchoring;
    }

    @Override
    public Point getAnchoringSourcePosition() {
        return this.getRealPosition();
    }

    @Override
    public IAnchoringSourcePoint getAnchoringSourceFromPoint() {
        PMLine ln1st = this.getLine1st();
        PMLine ln2nd = this.getLine2nd();
        PMPoint fromPoint = null;
        if (ln1st != null && ln2nd == null) {
            fromPoint = ln1st.getPoint1st();
        } else if (ln1st == null && ln2nd != null) {
            fromPoint = ln2nd.getPoint2nd();
        }
        return fromPoint;
    }

    @Override
    public PolygonCorner getAnchoringDestinationPositionOnPolygon() {
        return this.getPolygonCorner();
    }

    @Override
    public PolygonCorner getAnchoringSourcePositionOnPolygon() {
        return this.getPolygonCorner();
    }

    @Override
    public Double getAnchoringSourceWidth() {
        return this.getWidth();
    }

    @Override
    public Rectangle getAnchoringSourceOuterBounds() {
        return this.getOuterBounds();
    }

    @Override
    public IAnchoringSourcePoint getSourceEndPoint() {
        PMPoint point = this.isEndPointOfLineShapeFigure() ? this : null;
        return point;
    }

    @Override
    public IAnchoringSourcePoint getSourceNoneEndPoint() {
        PMPoint point = this.isEndPointOfLineShapeFigure() ? null : this;
        return point;
    }

    @Override
    public IAnchoringSourceLine getSourceLine() {
        return null;
    }

    @Override
    public IAnchoringSourcePoint.Force getForce() {
        IAnchoringSourcePoint.Force force = IAnchoringSourcePoint.FORCE_NONE;
        PMLine neighbourLine = null;
        if (this.line1st != null && this.line2nd == null) {
            neighbourLine = this.line1st;
        } else if (this.line1st == null && this.line2nd != null) {
            neighbourLine = this.line2nd;
        }
        if (neighbourLine != null) {
            switch (neighbourLine.getForce()) {
                case 2: {
                    force = IAnchoringSourcePoint.FORCE_HORIZONTAL;
                    break;
                }
                case 3: {
                    force = IAnchoringSourcePoint.FORCE_VERTICAL;
                }
            }
        }
        return force;
    }

    @Override
    public Collection<? extends IAnchoringSourceContributor> getChildSourceContributors() {
        return null;
    }

    @Override
    public Rectangle getSourceContributorOuterBounds() {
        return this.getOuterBounds();
    }

    @Override
    public IAnchoringDestination getRootDestination() {
        return this.getPlanElement().getRootDestination(this);
    }

    @Override
    public IAnchoringSourceContributor getDestinationRelatedSourceContributor() {
        PMFigure relatedDestinations = null;
        PMPlanObject planObject = this.getPlanObject();
        if (planObject instanceof PMFigure) {
            PMFigure figure;
            relatedDestinations = figure = (PMFigure)planObject;
        }
        return relatedDestinations;
    }

    public Collection<IAnchoring> getIAnchorings() {
        return this.pointToPointAnchorings;
    }

    @Override
    public Point getAnchoringDestinationPosition() {
        return this.getRealPosition();
    }

    @Override
    public Double getAnchoringDestinationWidth() {
        return this.getWidth();
    }

    @Override
    public Rectangle getAnchoringDestinationOuterBounds() {
        return this.getOuterBounds();
    }

    @Override
    public IAnchoringDestinationFigure getDestinationFigure() {
        return null;
    }

    @Override
    public IAnchoringDestinationPoint getDestinationPoint() {
        return this;
    }

    @Override
    public IAnchoringDestinationLine getDestinationLine() {
        return null;
    }

    @Override
    public Collection<? extends IAnchoringDestinationContributor> getChildDestinationContributors() {
        return null;
    }

    @Override
    public Rectangle getDestinationContributorOuterBounds() {
        return this.getOuterBounds();
    }

    private Rectangle getOuterBounds() {
        this.updateOuterBoundsCache();
        return this.boundsCache;
    }

    private Double getWidth() {
        this.updateWidthCache();
        return this.widthCache;
    }

    private boolean isEndPointOfLineShapeFigure() {
        PMPlanObject planObject = this.getPlanObject();
        boolean isEndPoint = planObject instanceof PMFigureLineShape ? this.getLine1st() == null || this.getLine2nd() == null : planObject instanceof PMFigureDot;
        return isEndPoint;
    }

    @Override
    protected String getUid() {
        return this.getPersistentPoint().getUid();
    }

    @Override
    public Point getPosition() {
        this.updatePositionCache();
        return this.positionCache;
    }

    @Override
    public boolean getCornerRadiusInherited() {
        this.updatePositionCache();
        return this.positionCacheCornerRadiusInherited;
    }

    @Override
    public boolean getCornerRadiusInfinity() {
        this.updatePositionCache();
        return this.positionCacheCornerRadiusInfinity;
    }

    @Override
    public double getCornerRadius() {
        this.updatePositionCache();
        return this.positionCacheCornerRadius;
    }

    @Override
    public void setPosition(Point position) {
        assert (position != null) : "position is null";
        this.persistent.setPosition(position);
        this.flushPlanObjectsGeometryCache();
    }

    @Override
    public void setCornerRadiusInherited() {
        this.persistent.setCornerRadiusInherited();
        this.flushPlanObjectsGeometryCache();
    }

    @Override
    public void setCornerRadiusInfinity() {
        this.persistent.setCornerRadiusInfinity();
        this.flushPlanObjectsGeometryCache();
    }

    @Override
    public void setCornerRadius(double cornerRadius) {
        assert (cornerRadius >= -1.0E-10);
        this.persistent.setCornerRadius(cornerRadius);
        this.flushPlanObjectsGeometryCache();
    }

    public Point getRealPosition() {
        this.updateRealPositionCache();
        return this.realPositionCache;
    }

    private PolygonCorner getPolygonCorner() {
        this.updatePolygonCornerCache();
        return this.polygonCornerCache;
    }

    private void flushPlanObjectsGeometryCache() {
        PMPointList pointLst = this.getPointList();
        if (pointLst != null) {
            pointLst.flushPlanObjectsGeometryCaches();
        }
    }

    protected void flushGeometryCaches() {
        this.polygonCornerCacheIsValid = false;
        this.widthCacheIsValid = false;
        this.positionCacheIsValid = false;
        this.realPositionCacheIsValid = false;
        this.boundsCacheIsValid = false;
    }

    private void updatePolygonCornerCache() {
        if (!this.polygonCornerCacheIsValid) {
            this.polygonCornerCache = this.getPlanObject().getPolygonCorner(this);
            this.polygonCornerCacheIsValid = true;
        }
    }

    private void updateWidthCache() {
        if (!this.widthCacheIsValid) {
            this.widthCache = null;
            PMPlanObject planObject = this.getPlanObject();
            if (planObject != null) {
                this.widthCache = planObject.getWidth();
            }
            this.widthCacheIsValid = true;
        }
    }

    private void updatePositionCache() {
        if (!this.positionCacheIsValid) {
            this.positionCache = this.persistent.getPosition();
            this.positionCacheCornerRadiusInherited = this.persistent.getCornerRadiusInherited();
            if (!this.positionCacheCornerRadiusInherited) {
                this.positionCacheCornerRadiusInfinity = this.persistent.getCornerRadiusInfinity();
                if (!this.positionCacheCornerRadiusInfinity) {
                    this.positionCacheCornerRadius = this.persistent.getCornerRadius();
                }
            }
            this.positionCacheIsValid = true;
        }
    }

    private void updateRealPositionCache() {
        if (!this.realPositionCacheIsValid) {
            this.realPositionCache = this.polygonCornerCache != null ? this.getPolygonCorner().getRealPosition() : this.getPosition();
            this.realPositionCacheIsValid = true;
        }
    }

    private void updateOuterBoundsCache() {
        if (!this.boundsCacheIsValid) {
            Double widthDouble = this.getWidth();
            double width = widthDouble == null ? 0.0 : widthDouble;
            this.boundsCache = new Rectangle(this.getRealPosition(), new Dimension(width, width));
            this.boundsCacheIsValid = true;
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + To.makeNotNull((Object)this.positionCache).toString();
    }

    static class PointFactory
    extends PMPlanModelObject.PlanModelObjectFactory {
        PointFactory() {
        }

        @Override
        public PMPlanModelObject create(PlanModelMgr planModelMgr, EncodableObjectBase eo) {
            return new PMPoint(planModelMgr, (EOPoint)eo);
        }

        @Override
        public List<? extends EOEncodableObject> getChildren(EncodableObjectBase eo) {
            EOPoint eoPoint = (EOPoint)eo;
            List<? extends EOEncodableObject> children = super.getChildren(eo);
            children.add((EOEncodableObject)eoPoint.getAnchoring());
            return children;
        }
    }
}

