/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.appearance;

import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IFillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;

public class FillAppearance
implements IFillAppearance {
    private FillStyle fillStyle = DEFAULT_FILLSTYLE;
    private int fillColorFgRed = 255;
    private int fillColorFgGreen = 255;
    private int fillColorFgBlue = 255;
    private int fillColorFgAlpha = 255;
    private int fillColorBgRed = 0;
    private int fillColorBgGreen = 0;
    private int fillColorBgBlue = 0;
    private int fillColorBgAlpha = 0;

    public static void copy(IFillAppearanceRO source, IFillAppearance target) {
        target.setFillStyle(source.getFillStyle());
        target.setFillColor(source.getFillColor());
    }

    public FillAppearance() {
    }

    public FillAppearance(IFillAppearanceRO source) {
        this.setAppearanceFrom(source);
    }

    @Override
    public FillColor getFillColor() {
        return new FillColor(this.fillColorFgRed, this.fillColorFgGreen, this.fillColorFgBlue, this.fillColorFgAlpha, this.fillColorBgRed, this.fillColorBgGreen, this.fillColorBgBlue, this.fillColorBgAlpha);
    }

    @Override
    public void setFillColor(FillColor fillColor) {
        assert (fillColor != null);
        this.fillColorFgRed = fillColor.foregroundColor.r;
        this.fillColorFgGreen = fillColor.foregroundColor.g;
        this.fillColorFgBlue = fillColor.foregroundColor.b;
        this.fillColorFgAlpha = fillColor.foregroundAlpha;
        this.fillColorBgRed = fillColor.backgroundColor.r;
        this.fillColorBgGreen = fillColor.backgroundColor.g;
        this.fillColorBgBlue = fillColor.backgroundColor.b;
        this.fillColorBgAlpha = fillColor.backgroundAlpha;
    }

    @Override
    public void setFillStyle(FillStyle fillStyle) {
        assert (fillStyle != null);
        this.fillStyle = fillStyle;
    }

    @Override
    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    @Override
    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof IFillAppearanceRO)) {
            return;
        }
        IFillAppearanceRO fill = (IFillAppearanceRO)appearance;
        this.setFillColor(fill.getFillColor());
        this.setFillStyle(fill.getFillStyle());
    }

    @Override
    public IAppearanceRO getAppearanceAsCopy() {
        return new FillAppearance(this);
    }
}

