/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import java.util.List;

public class ActionTool {
    public static void movePlanElements(List planElements, GeoVector distance) {
        for (IPMPlanElementRW planElement : planElements) {
            ActionTool.movePlanElement(planElement, distance);
        }
    }

    public static void movePlanElement(IPMPlanElementRW planElement, GeoVector distance) {
        int i = 0;
        while (i < planElement.getFigureCount()) {
            ActionTool.moveFigure(planElement.getFigureRW(i), distance);
            ++i;
        }
    }

    public static void moveFigure(IPMFigureRW figure, GeoVector distance) {
        ActionTool.movePlanObject(figure, distance);
        int i = 0;
        while (i < figure.getGraphicalSupplementCount()) {
            ActionTool.moveGraphicalSupplement(figure.getGraphicalSupplementRW(i), distance);
            ++i;
        }
    }

    public static void moveGraphicalSupplement(IPMGraphicalSupplementRW graphicalSupplement, GeoVector distance) {
        ActionTool.movePlanObject(graphicalSupplement, distance);
    }

    public static void movePlanObject(IPMPlanObjectRW planObject, GeoVector distance) {
        IPMPointListRW pointList = planObject.getPointListRW();
        int i = 0;
        while (i < pointList.getPointCount()) {
            ActionTool.movePoint(pointList.getPointRW(i), distance);
            ++i;
        }
    }

    public static void movePoint(IPMPointRW point, GeoVector distance) {
        point.setPosition(point.getPosition().movePoint(distance));
    }

    public static Point[] initializeSourcePositionsOfPlanObject(IPMPlanObjectRW planObject) {
        Point[] sourcePositionArray = new Point[planObject.getPointListRW().getPointCount()];
        int i = 0;
        while (i < planObject.getPointListRW().getPointCount()) {
            sourcePositionArray[i] = planObject.getPointListRW().getPointRW(i).getPosition();
            ++i;
        }
        return sourcePositionArray;
    }

    public static Point[] calculateTargetPositionOfPlanObject(IPMPlanObjectRW planObject, GeoVector distance) {
        Point[] targetPositionArray = new Point[planObject.getPointListRW().getPointCount()];
        int i = 0;
        while (i < planObject.getPointListRW().getPointCount()) {
            targetPositionArray[i] = planObject.getPointListRW().getPointRW(i).getPosition().movePoint(distance);
            ++i;
        }
        return targetPositionArray;
    }

    public static void setPositionOfPlanElement(IPMPlanObjectRW planObject, Point[] positionArray) {
        int i = 0;
        while (i < planObject.getPointListRW().getPointCount()) {
            planObject.getPointListRW().getPointRW(i).setPosition(positionArray[i]);
            ++i;
        }
    }
}

