/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ACSetNamePlanElement
extends Action {
    private final IPMPlanElementRW planElement;
    private final String newName;
    private String oldName;

    public ACSetNamePlanElement(ActionContext actionContext, IPMPlanElementRW planElement, String name) {
        super(actionContext);
        assert (planElement != null) : "ref to planElement is null";
        this.planElement = planElement;
        this.newName = name;
    }

    @Override
    protected void initializeState() {
        this.oldName = this.planElement.getName();
    }

    @Override
    protected void setStateToPost() {
        this.planElement.setName(this.newName);
    }

    @Override
    protected void setStateToPre() {
        this.planElement.setName(this.oldName);
    }

    @Override
    public boolean isDupe(Action a) {
        ACSetNamePlanElement dupeA;
        boolean isDupe = false;
        if (a instanceof ACSetNamePlanElement && (dupeA = (ACSetNamePlanElement)a).getPlanElement().equals(this.getPlanElement()) && dupeA.getNewName().equals(this.getNewName())) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    @Override
    public Set<IModelChangeRW> getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.planElement, 2));
        return changes;
    }

    @Override
    public Collection<IEntryOfCompressedList> getEntriesForCompressedReactionList() {
        return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionSetNameAgent().getEntryForCompressedList(this.getPlanElement(), this.newName, this.getActionContext()));
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.planElement;
    }

    public String getNewName() {
        return this.newName;
    }

    public IPMPlanElementRW getPlanElement() {
        return this.planElement;
    }

    public String toString() {
        return "ACSetNamePlanElement (plan element " + this.planElement + ", new name" + this.newName + ")";
    }
}

