/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.java.New;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACAbstractModifyGeometryPointsInvariant;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.AnchoringContributorTraverser;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ACRemove1Point
extends Action {
    private final IPMPointRW pointToRemove;
    private final IPMLineRW lineToRemove;
    private boolean pointToRemoveIsPoint1st;
    private int indexOfPointToRemove;
    private int indexOfLineToRemove;
    private List preStateGoemetry;

    public ACRemove1Point(ActionContext actionContext, IPMPointRW pointToRemove, IPMLineRW lineToRemove) {
        super(actionContext);
        assert (pointToRemove != null);
        assert (lineToRemove != null);
        this.lineToRemove = lineToRemove;
        this.pointToRemove = pointToRemove;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.lineToRemove.getISemanticalUnitRW();
    }

    @Override
    public boolean isNop() {
        return false;
    }

    @Override
    public boolean isDupe(Action a) {
        return false;
    }

    @Override
    protected void initializeState() {
        assert (this.lineToRemove.getPoint1stRW() == this.pointToRemove || this.lineToRemove.getPoint2ndRW() == this.pointToRemove);
        this.preStateGoemetry = ACAbstractModifyGeometryPointsInvariant.getPreStateGeometry(this.pointToRemove.getPlanObjectRW());
        IPMPointListRW pointList = this.pointToRemove.getPointListRW();
        this.indexOfPointToRemove = pointList.getPointIndex(this.pointToRemove);
        assert (this.indexOfPointToRemove >= 0) : "trying to delete a point that was already deleted";
        this.indexOfLineToRemove = pointList.getLineIndex(this.lineToRemove);
        assert (this.indexOfLineToRemove >= 0) : "trying to delete a line that was already deleted";
        if (this.pointToRemove == this.lineToRemove.getPoint1stRW()) {
            this.pointToRemoveIsPoint1st = true;
            this.indexOfLineToRemove = this.indexOfPointToRemove;
        } else {
            this.pointToRemoveIsPoint1st = false;
        }
    }

    @Override
    protected void setStateToPost() {
        IPMPointListRW pointList = this.pointToRemove.getPointListRW();
        pointList.removePoint(this.indexOfPointToRemove);
        pointList.removeLine(this.indexOfLineToRemove);
        if (this.pointToRemoveIsPoint1st) {
            IPMLineRW line1st = this.pointToRemove.getLine1stRW();
            IPMPointRW point2nd = this.lineToRemove.getPoint2ndRW();
            if (line1st != null) {
                line1st.setPoint2nd(point2nd);
            }
            if (point2nd != null) {
                point2nd.setLine1st(line1st);
            }
        } else {
            IPMPointRW point1st = this.lineToRemove.getPoint1stRW();
            IPMLineRW line2nd = this.pointToRemove.getLine2ndRW();
            if (point1st != null) {
                point1st.setLine2nd(line2nd);
            }
            if (line2nd != null) {
                line2nd.setPoint1st(point1st);
            }
        }
    }

    @Override
    protected void setStateToPre() {
        IPMPointListRW pointList = this.pointToRemove.getPointListRW();
        pointList.addPoint(this.pointToRemove, this.indexOfPointToRemove);
        pointList.addLine(this.lineToRemove, this.indexOfLineToRemove);
        if (this.pointToRemoveIsPoint1st) {
            IPMLineRW line1st = this.pointToRemove.getLine1stRW();
            IPMPointRW point2nd = this.lineToRemove.getPoint2ndRW();
            if (line1st != null) {
                line1st.setPoint2nd(this.pointToRemove);
            }
            if (point2nd != null) {
                point2nd.setLine1st(this.lineToRemove);
            }
        } else {
            IPMPointRW point1st = this.lineToRemove.getPoint1stRW();
            IPMLineRW line2nd = this.pointToRemove.getLine2ndRW();
            if (point1st != null) {
                point1st.setLine2nd(this.lineToRemove);
            }
            if (line2nd != null) {
                line2nd.setPoint1st(this.pointToRemove);
            }
        }
    }

    @Override
    public ActionIterator getPreActionIterator() {
        ArrayList<IAnchoringSourceContributor> sourceContributors = new ArrayList<IAnchoringSourceContributor>(2);
        sourceContributors.add(this.pointToRemove);
        sourceContributors.add(this.lineToRemove);
        ArrayList<IAnchoringSourceContributor> destinationContributors = sourceContributors;
        Collection<IAnchoring> anchoringsToRemove = AnchoringContributorTraverser.getAllAnchorings(sourceContributors, destinationContributors);
        PredeterminedActionIterator preActionIterator = new PredeterminedActionIterator(anchoringsToRemove.size());
        for (IPMAnchoringRW iPMAnchoringRW : anchoringsToRemove) {
            preActionIterator.addAction(ActionFactory.createACRemoveAnchoring(this.getActionContext(), iPMAnchoringRW));
        }
        return preActionIterator;
    }

    public Collection getEntriesForCompressedReactionList() {
        IPMPlanObjectRW planObject = this.pointToRemove.getPlanObjectRW();
        if (planObject instanceof IPMFigureRW) {
            IPMFigureRW figure = (IPMFigureRW)planObject;
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionChangeGeometryFigureAgent().getEntryForCompressedList(figure, this.preStateGoemetry, this.getActionContext()));
        }
        if (planObject instanceof IPMGraphicalSupplementRW) {
            HashMap changedSupplements = New.hashMap((int)1);
            changedSupplements.put((IPMGraphicalSupplementRW)planObject, this.preStateGoemetry);
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionModifySupplementAgent().getEntryForCompressedList(changedSupplements, this.getActionContext()));
        }
        assert (false) : "point not part of supplement or figure";
        return null;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(2);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.pointToRemove, 3));
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.lineToRemove, 3));
        return changes;
    }
}

