/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACAbstractModifyGeometryPointsInvariant;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ACMovePoint
extends ACAbstractModifyGeometryPointsInvariant {
    private final GeoVector distance;
    private final IPMPointRW point;
    private Point sourcePosition;
    private Point targetPosition;

    public ACMovePoint(ActionContext context, IPMPointRW point, GeoVector distance, boolean removeSourceAnchorings) {
        super(point.getPlanObjectRW(), removeSourceAnchorings, context);
        this.point = point;
        this.distance = distance;
    }

    @Override
    protected void initializeState() {
        super.initializeState();
        this.sourcePosition = this.point.getPosition();
        this.targetPosition = this.sourcePosition.movePoint(this.distance);
    }

    @Override
    protected void setStateToPost() {
        this.point.setPosition(this.targetPosition);
    }

    @Override
    protected void setStateToPre() {
        this.point.setPosition(this.sourcePosition);
    }

    @Override
    public boolean isDupe(Action a) {
        ACMovePoint dupeA;
        boolean isDupe = false;
        if (a instanceof ACMovePoint && (dupeA = (ACMovePoint)a).getPoint() == this.getPoint() && dupeA.getDistance() == this.getDistance()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    public boolean isNop() {
        boolean isNop = false;
        if (this.distance.abs() <= 1.0E-10) {
            isNop = true;
        }
        return isNop;
    }

    @Override
    protected Collection getPrimaryAnchoringSourceContributors() {
        ArrayList<IAnchoringDestinationContributor> anchoringContributors = new ArrayList<IAnchoringDestinationContributor>(3);
        anchoringContributors.add(this.point);
        IPMLineRW line1st = this.point.getLine1stRW();
        IPMLineRW line2nd = this.point.getLine2ndRW();
        if (line1st != null) {
            anchoringContributors.add(line1st);
        }
        if (line2nd != null) {
            anchoringContributors.add(line2nd);
        }
        return anchoringContributors;
    }

    @Override
    protected Collection getSecondaryAnchoringSourceContributors() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected Collection getAnchoringDestinationContributors() {
        ArrayList<IAnchoringDestinationContributor> anchoringContributors = new ArrayList<IAnchoringDestinationContributor>(3);
        anchoringContributors.add(this.point);
        IPMLineRW line1st = this.point.getLine1stRW();
        IPMLineRW line2nd = this.point.getLine2ndRW();
        if (line1st != null) {
            anchoringContributors.add(line1st);
        }
        if (line2nd != null) {
            anchoringContributors.add(line2nd);
        }
        return anchoringContributors;
    }

    public GeoVector getDistance() {
        return this.distance;
    }

    public IPMPointRW getPoint() {
        return this.point;
    }

    public String toString() {
        return "ACMovePoint (point " + this.point + ", distance" + this.distance + ")";
    }
}

