/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointToPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringPoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import java.util.HashSet;
import java.util.Set;

public class ACCreateAnchoringPointToPoint
extends ACCreateAnchoringPoint {
    private final IPMPointRW targetPoint;
    private IPMAnchoringPointToPointRW anchoringPointToPoint;

    public ACCreateAnchoringPointToPoint(ActionContext actionContext, IPMPointRW point, IPMPointRW targetPoint) {
        super(actionContext, point);
        assert (targetPoint != null) : "ref to targetPoint is null";
        this.targetPoint = targetPoint;
    }

    @Override
    protected void initializeState() {
        this.anchoringPointToPoint = this.getIPlanModelObjectFactoryRW().createPMAnchoringPointToPointRW();
        super.initializeState();
        this.anchoringPointToPoint.setTargetPoint(this.targetPoint);
    }

    @Override
    protected void setStateToPost() {
        super.setStateToPost();
        this.targetPoint.addPointToPointAnchoring(this.anchoringPointToPoint, this.targetPoint.getPointToPointAnchoringCount());
    }

    @Override
    protected void setStateToPre() {
        super.setStateToPre();
        assert (this.targetPoint.getPointToPointAnchoringIndex(this.anchoringPointToPoint) == this.targetPoint.getPointToPointAnchoringCount() - 1) : "anchoring is not at the expected index";
        this.targetPoint.removePointToPointAnchoring(this.targetPoint.getPointToPointAnchoringCount() - 1);
    }

    @Override
    public boolean isDupe(Action a) {
        ACCreateAnchoringPointToPoint dupeA;
        boolean isDupe = false;
        if (a instanceof ACCreateAnchoringPointToPoint && (dupeA = (ACCreateAnchoringPointToPoint)a).getPoint() == this.getPoint() && dupeA.getTargetPoint() == this.getTargetPoint()) {
            isDupe = true;
        }
        return isDupe;
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.anchoringPointToPoint, 1));
        return changes;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        assert (this.getPoint().getPlanElementRW().getPlanRW() == this.targetPoint.getPlanElementRW().getPlanRW()) : "the plan should be unique";
        return this.getPoint().getPlanElementRW().getPlanRW();
    }

    public IPMPointRW getTargetPoint() {
        return this.targetPoint;
    }

    @Override
    public IPMAnchoringPointRW getAnchoringPoint() {
        return this.anchoringPointToPoint;
    }

    public String toString() {
        return "ACCreateAnchoringPointToPoint (target point " + this.targetPoint + ")";
    }
}

