/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.pn.check;

import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.fmc.pn.access.readonly.IPMPlanElementFMCPNEdgeRO;
import com.arcway.planagent.planmodel.fmc.pn.access.readonly.IPMPlanElementFMCPNMediumRO;
import com.arcway.planagent.planmodel.fmc.pn.access.readonly.IPMPlanElementFMCPNMessageRO;
import com.arcway.planagent.planmodel.fmc.pn.access.readonly.IPMPlanElementFMCPNPlaceRO;
import com.arcway.planagent.planmodel.fmc.pn.access.readonly.IPMPlanElementFMCPNTransitionRO;

public class PNValidityMatrix {
    public static boolean isPointToFigureAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationFigure destination) {
        boolean anchoringIsPossible = false;
        if (PNValidityMatrix.isEdge(source.getAnchoringFigure()) && PNValidityMatrix.isElement(destination.getAnchoringFigure())) {
            anchoringIsPossible |= true;
        } else if (PNValidityMatrix.isMedium(source.getAnchoringFigure()) && PNValidityMatrix.isMessage(destination.getAnchoringFigure())) {
            anchoringIsPossible |= true;
        }
        return anchoringIsPossible &= source.getAnchoringFigure().getPlanElementRO() != destination.getAnchoringFigure().getPlanElementRO();
    }

    public static boolean isPointToPointAnchoringPossible() {
        return false;
    }

    public static boolean isTouchValid() {
        boolean touchIsValid = false;
        touchIsValid |= PNValidityMatrix.isDirectedTouchValid();
        return touchIsValid |= PNValidityMatrix.isDirectedTouchValid();
    }

    private static boolean isDirectedTouchValid() {
        boolean touchIsValid = true;
        return touchIsValid;
    }

    private static boolean isEdge(IPMFigureRO figure) {
        boolean isEdge = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        isEdge |= planElement instanceof IPMPlanElementFMCPNEdgeRO;
        return isEdge |= planElement instanceof IPMPlanElementFMCPNMessageRO;
    }

    private static boolean isElement(IPMFigureRO figure) {
        boolean isElement = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        isElement |= planElement instanceof IPMPlanElementFMCPNTransitionRO;
        return isElement |= PNValidityMatrix.isPlace(figure);
    }

    private static boolean isPlace(IPMFigureRO figure) {
        boolean isPlace = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isPlace |= planElement instanceof IPMPlanElementFMCPNPlaceRO;
    }

    private static boolean isMessage(IPMFigureRO figure) {
        boolean isPlace = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isPlace |= planElement instanceof IPMPlanElementFMCPNMessageRO;
    }

    private static boolean isMedium(IPMFigureRO figure) {
        boolean isPlace = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isPlace |= planElement instanceof IPMPlanElementFMCPNMediumRO;
    }
}

