/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.bd.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACCreateAnchorRelativePosition;
import com.arcway.planagent.planmodel.actions.ACCreateFigurePlane;
import com.arcway.planagent.planmodel.actions.ACCreatePlanElement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDChannelRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateFMCBDChannel
extends PredeterminedLengthTransaction {
    private static final int BASIC_STEPS = 2;
    private static final double MINIMAL_CORNER_RADIUS = 2.0;
    private Points outline;
    private int[] outlineForce;
    private ILineAppearanceRO lineAppearance;
    private IFillAppearanceRO fillAppearance;
    private IPMPlanElementFMCBDChannelRO createdChannel;

    public TACreateFMCBDChannel(IPMPlanRO plan, ActionParameters actionParameters, Points outline, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance) {
        super(2 + outline.size(), (IPMPlanModelObjectRW)((IPMPlanRW)plan), actionParameters);
        assert (lineAppearance != null) : "lineAppearance is null";
        this.transactionAssertion(outline.size() > 1, "not enough points for an outline");
        this.transactionAssertion(lineAppearance.getCornerRadius() > 2.0 || lineAppearance.getCornerRadiusInfinity(), "the channels's corner radius is too small");
        try {
            this.outline = outline;
            this.outlineForce = LineHelper.createAlternatingLineForcesClosed((Points)outline);
            this.lineAppearance = lineAppearance;
            this.fillAppearance = fillAppearance;
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                return this.createChannelAction();
            }
            case 1: {
                this.createdChannel = (IPMPlanElementFMCBDChannelRO)((ACCreatePlanElement)previousActions.get(n - 1)).getCreatedPlanElement();
                return this.createOutlineAction((ACCreatePlanElement)previousActions.get(n - 1));
            }
        }
        return this.createNextAnchorPointAction(n - 2, (ACCreateFigurePlane)previousActions.get(1));
    }

    private Action createChannelAction() {
        return new ACCreatePlanElement(this.getActionContext(), (IPMPlanRW)this.getTransactionRoot(), "fmc.bd.channel");
    }

    private Action createOutlineAction(ACCreatePlanElement previousAction) {
        return new ACCreateFigurePlane(this.getActionContext(), "outline", previousAction.getCreatedPlanElement(), this.outline, this.outlineForce, this.lineAppearance, this.fillAppearance, false);
    }

    private Action createNextAnchorPointAction(int n, ACCreateFigurePlane createFigure) {
        return new ACCreateAnchorRelativePosition(this.getActionContext(), createFigure.getFigure().getPointListRW().getLineRW(n), 0.5);
    }

    public IPMPlanElementFMCBDChannelRO getCreatedChannel() {
        return this.createdChannel;
    }

    public String toString() {
        return "TACreateFMCBDChannel (Points " + this.outline + ")";
    }
}

