/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.routing;

import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.geometry.polygon.PolygonLine;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.actions.ACMovePlanElementStructure;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.routing.AbstractRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import java.util.Collections;

public class SetPointOnFigureRouter
extends AbstractRouter {
    public SetPointOnFigureRouter() {
        super(IAnchoringSourcePoint.class, IAnchoringDestinationFigure.class);
    }

    public ActionIterator routeWhenClassesAreChecked(IAnchoringSource source, IAnchoringDestination destination, ActionContext actionContext, IRoutingParameters routingParameters, IRoutingManager routingManger) {
        IAnchoringSourcePoint src = (IAnchoringSourcePoint)source;
        IPMPlanElementRO pe = src.getAnchoringFigure().getPlanElementRO();
        PredeterminedActionIterator actions = new PredeterminedActionIterator(1);
        GeoVector distanceOfTargetFigure = routingParameters.getDistanceWhenFiguresAreMoved((IPMFigureRW)destination.getAnchoringFigure());
        if (distanceOfTargetFigure == null) {
            IAnchoringDestinationFigure dest = (IAnchoringDestinationFigure)destination;
            Polygon polygon = dest.getAnchoringDestinationPositionAsPolygon();
            if (polygon == null) {
                Corners corners = new Corners(dest.getAnchoringDestinationPosition(), 0.0);
                polygon = new Polygon(corners, dest.isAnchoringDestinationClosedDraw());
            }
            double distance = Double.POSITIVE_INFINITY;
            PolygonLine closestLine = null;
            Corners tmp = new Corners(polygon.getPointsApproximated(), 0.0);
            polygon = new Polygon(tmp, polygon.isClosed());
            int count = polygon.getPolygonCornerPointCount();
            count -= polygon.isClosed() ? 0 : 1;
            int i = 0;
            while (i < count) {
                PolygonLine line = polygon.getPolygonLine(i);
                double newDistance = line.getDistanceToBorder(src.getAnchoringSourcePosition());
                if (closestLine == null || newDistance < distance) {
                    closestLine = line;
                    distance = newDistance;
                }
                if (Geo.isZero((double)distance)) break;
                ++i;
            }
            if (!Geo.isZero((double)distance)) {
                assert (closestLine != null) : "no closest line found";
                assert (closestLine.line != null) : "closest line has no line object";
                StraightLine closestStriaghtLine = new StraightLine(closestLine.line);
                Point target = closestStriaghtLine.getPerpendicular(src.getAnchoringSourcePosition()).getInterceptPoint(closestStriaghtLine);
                ACMovePlanElementStructure moveFigure = new ACMovePlanElementStructure(actionContext, Collections.singletonList(pe), new GeoVector(src.getAnchoringSourcePosition(), target), false);
                actions.addAction((Action)moveFigure);
            }
        } else if (!distanceOfTargetFigure.isZero()) {
            ACMovePlanElementStructure movePE = new ACMovePlanElementStructure(actionContext, Collections.singletonList(pe), distanceOfTargetFigure, false);
            actions.addAction((Action)movePE);
        }
        return actions;
    }
}

