/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.base.transactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigurePlane;
import com.arcway.planagent.planmodel.actions.ACCreatePlanElement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMPlanElementPlaneCommentRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreatePlaneComment
extends PredeterminedLengthTransaction {
    private static final int STEPS = 2;
    private Points commentPoints;
    private int[] commentForce;
    private ILineAppearanceRO lineAppearance;
    private IFillAppearanceRO fill;
    private IPMPlanElementPlaneCommentRO createdComment;

    public TACreatePlaneComment(IPMPlanRO plan, ActionParameters actionParameters, Points commentPoints, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanRW)plan), actionParameters);
        assert (lineAppearance != null) : "ILineAppearance is null";
        this.transactionAssertion(commentPoints.size() >= 4, "not enough points describing comment figure");
        this.transactionAssertion(Geo.equals((double)0.0, (double)lineAppearance.getCornerRadius()), "the comment's corner radius is not 0");
        try {
            this.commentPoints = commentPoints;
            this.commentForce = LineHelper.createAlternatingLineForcesClosed(commentPoints);
            this.lineAppearance = lineAppearance;
            this.fill = fillAppearance;
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                return this.createCommentAction();
            }
            case 1: {
                this.createdComment = (IPMPlanElementPlaneCommentRO)((ACCreatePlanElement)previousActions.get(n - 1)).getCreatedPlanElement();
                return this.createOutlineAction((ACCreatePlanElement)previousActions.get(n - 1));
            }
        }
        return null;
    }

    private Action createCommentAction() {
        return new ACCreatePlanElement(this.getActionContext(), (IPMPlanRW)this.getTransactionRoot(), "fmc.cm.planecomment");
    }

    private Action createOutlineAction(ACCreatePlanElement previousAction) {
        return new ACCreateFigurePlane(this.getActionContext(), "outline", previousAction.getCreatedPlanElement(), this.commentPoints, this.commentForce, this.lineAppearance, this.fill, false);
    }

    public IPMPlanElementPlaneCommentRO getCreatedPlaneComment() {
        return this.createdComment;
    }

    public String toString() {
        return "TACreatePlaneComment (Points " + this.commentPoints + ")";
    }
}

