/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.base.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementImageRW;
import com.arcway.planagent.planmodel.cm.actions.ACCreateGraphicalSupplementImage;
import com.arcway.planagent.planmodel.cm.actions.ACSetImageGraphicalSupplementImage;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateImageSupplement
extends PredeterminedLengthTransaction {
    private static final int STEPS = 2;
    private final Points imagePoints;
    private final IStreamResource image;
    private final String commentRole;
    private final IPMFigureRW commentFigure;

    public TACreateImageSupplement(IPMFigureRO imageSupplementFigure, String imageSupplementRole, ActionParameters actionParameters, Points imagePoints, IStreamResource image) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanElementRW)imageSupplementFigure.getPlanElementRO()), actionParameters);
        this.commentFigure = (IPMFigureRW)imageSupplementFigure;
        this.commentRole = imageSupplementRole;
        this.imagePoints = imagePoints;
        this.image = image;
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                int[] force = new int[this.imagePoints.size()];
                try {
                    force = LineHelper.createAlternatingLineForcesClosed(this.imagePoints);
                }
                catch (EXTransactionNotValidException e) {
                    this.setInvalid(e);
                }
                ACCreateGraphicalSupplementImage action = new ACCreateGraphicalSupplementImage(this.getActionContext(), this.imagePoints, force, this.commentFigure, this.commentRole);
                return action;
            }
            case 1: {
                IPMGraphicalSupplementImageRW imageFigure = (IPMGraphicalSupplementImageRW)((ACCreateGraphicalSupplementImage)previousActions.get(n - 1)).getGraphicalSupplement();
                return new ACSetImageGraphicalSupplementImage(this.getActionContext(), imageFigure, this.image);
            }
        }
        return null;
    }
}

