/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.base.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithImageSupplementRO;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithImageSupplementRW;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementImageRW;
import com.arcway.planagent.planmodel.cm.actions.ACCreateGraphicalSupplementImage;
import com.arcway.planagent.planmodel.cm.actions.ACSetImageGraphicalSupplementImage;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateImageComment
extends PredeterminedLengthTransaction {
    private static final int STEPS = 2;
    private final IPMFigureRW commentFigure;
    private final String commentRole;
    private final Points points;
    private final IStreamResource image;

    public TACreateImageComment(IPMPlanElementWithImageSupplementRO planElementWithImage, ActionParameters actionParameters, Points imagePoints, IStreamResource image) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanElementWithImageSupplementRW)((Object)planElementWithImage)), actionParameters);
        this.points = imagePoints;
        this.commentFigure = ((IPMPlanElementWithImageSupplementRW)((Object)planElementWithImage)).getFigureForImageSupplementRW();
        this.commentRole = ((IPMPlanElementWithImageSupplementRW)((Object)planElementWithImage)).getImageSupplementRole();
        this.image = image;
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        int[] force = new int[this.points.size()];
        try {
            force = LineHelper.createAlternatingLineForcesClosed(this.points);
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
        switch (n) {
            case 0: {
                ACCreateGraphicalSupplementImage action = new ACCreateGraphicalSupplementImage(this.getActionContext(), this.points, force, this.commentFigure, this.commentRole);
                return action;
            }
            case 1: {
                IPMGraphicalSupplementImageRW textFigure = (IPMGraphicalSupplementImageRW)((ACCreateGraphicalSupplementImage)previousActions.get(n - 1)).getGraphicalSupplement();
                return new ACSetImageGraphicalSupplementImage(this.getActionContext(), textFigure, this.image);
            }
        }
        return null;
    }
}

