/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpmn.bpd.check;

import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.anchoring.AnchoringContributorTraverser;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDActivityRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDCompetencyRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDDataObjectNewRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDDataObjectRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDEventRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDGatewayRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDMessageRO;
import com.arcway.planagent.planmodel.bpmn.bpd.access.readonly.IPMPlanElementBPMNBPDRelationRO;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMPlanElementDotsCommentRO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class BPMNBPDValidityMatrix {
    public static boolean isPointToFigureAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationFigure destination) {
        boolean anchoringIsPossible = false;
        IPMFigureRO sourceFigure = source.getAnchoringFigure();
        IPMFigureRO destinationFigure = destination.getAnchoringFigure();
        if (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isActivity(destinationFigure)) {
            anchoringIsPossible |= true;
        } else if (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isEvent(destinationFigure, false)) {
            anchoringIsPossible |= true;
        } else if (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isGateway(destinationFigure)) {
            anchoringIsPossible |= true;
        } else if (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isDataObject(destinationFigure)) {
            anchoringIsPossible |= true;
        } else if (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isDataObjectNew(destinationFigure)) {
            anchoringIsPossible |= true;
        } else if (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isMessage(destinationFigure)) {
            anchoringIsPossible |= true;
        } else if (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isCompetency(destinationFigure)) {
            anchoringIsPossible |= true;
        } else if (BPMNBPDValidityMatrix.isEvent(sourceFigure, true) && BPMNBPDValidityMatrix.isActivity(destinationFigure)) {
            anchoringIsPossible |= true;
        }
        return anchoringIsPossible &= source.getAnchoringFigure().getPlanElementRO() != destination.getAnchoringFigure().getPlanElementRO();
    }

    public static boolean isPointToPointAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationPoint destination) {
        boolean anchoringIsPossible = false;
        return anchoringIsPossible;
    }

    public static boolean isTouchValid(IPMFigureRO figure1, IPMFigureRO figure2) {
        boolean touchIsValid = false;
        touchIsValid |= BPMNBPDValidityMatrix.isDirectedTouchValid(figure1, figure2);
        return touchIsValid |= BPMNBPDValidityMatrix.isDirectedTouchValid(figure2, figure1);
    }

    private static boolean isDirectedTouchValid(IPMFigureRO sourceFigure, IPMFigureRO destinationFigure) {
        boolean touchIsValid = true;
        touchIsValid = BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isEvent(destinationFigure, false) ? (touchIsValid |= true) : (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isActivity(destinationFigure) ? (touchIsValid |= true) : (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isDataObject(destinationFigure) ? (touchIsValid |= true) : (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isDataObjectNew(destinationFigure) ? (touchIsValid |= true) : (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isMessage(destinationFigure) ? (touchIsValid |= true) : (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isGateway(destinationFigure) ? (touchIsValid |= true) : (BPMNBPDValidityMatrix.isRelation(sourceFigure) && BPMNBPDValidityMatrix.isCompetency(destinationFigure) ? (touchIsValid |= true) : (BPMNBPDValidityMatrix.isDotsComment(sourceFigure) ? (touchIsValid &= BPMNBPDValidityMatrix.isRelation(destinationFigure) || BPMNBPDValidityMatrix.isActivity(destinationFigure) || BPMNBPDValidityMatrix.isEvent(destinationFigure, false) || BPMNBPDValidityMatrix.isDataObject(destinationFigure) || BPMNBPDValidityMatrix.isDataObjectNew(destinationFigure) || BPMNBPDValidityMatrix.isMessage(destinationFigure) || BPMNBPDValidityMatrix.isCompetency(destinationFigure)) : (BPMNBPDValidityMatrix.isEvent(sourceFigure, true) && BPMNBPDValidityMatrix.isActivity(destinationFigure) ? (touchIsValid |= true) : (touchIsValid &= false)))))))));
        return touchIsValid;
    }

    public static boolean isCombinationValid(IPMFigureRO figure1, IPMFigureRO figure2) {
        IPMPlanElementRO planElement1 = figure1.getPlanElementRO();
        IPMPlanElementRO planElement2 = figure2.getPlanElementRO();
        return true;
    }

    public static boolean isLogicalOperatorConnectionValid(IPMFigureRO logicalOperator) {
        int numberOfIncomingEdges = logicalOperator.getPlanElementRO().getNumberOfIncomingEdges();
        int numberOfOutgoingEdges = logicalOperator.getPlanElementRO().getNumberOfOutgoingEdges();
        if (numberOfIncomingEdges != 1 && numberOfOutgoingEdges != 1 || numberOfIncomingEdges == 1 && numberOfOutgoingEdges == 1) {
            return false;
        }
        IPMPlanElementRO incomingPlanElement = null;
        IPMPlanElementRO outgoingPlanElement = null;
        ArrayList<IAnchoringDestinationContributor> destinationContributors = new ArrayList<IAnchoringDestinationContributor>();
        destinationContributors.add((IAnchoringDestinationContributor)logicalOperator);
        Collection anchorings = AnchoringContributorTraverser.getAllAnchorings(Collections.emptyList(), destinationContributors);
        if (numberOfIncomingEdges == 1) {
            for (IAnchoring anchoring : anchorings) {
                IPMAnchoringPointRO anchoringPoint;
                IPMFigureRO controlFlow = anchoring.getAnchoringSource().getAnchoringFigure();
                IPMPointListRO controlFlowPointList = controlFlow.getPointListRO();
                IPMPointRO startPoint = controlFlowPointList.getPointRO(0);
                IPMPointRO endPoint = controlFlowPointList.getPointRO(controlFlowPointList.getPointCount() - 1);
                if (logicalOperator.getPlanElementRO().isIncomingEdge(controlFlow)) {
                    anchoringPoint = startPoint.getAnchoringRO();
                    if (anchoringPoint == null) continue;
                    incomingPlanElement = anchoringPoint.getAnchoringDestination().getAnchoringFigure().getPlanElementRO();
                    continue;
                }
                anchoringPoint = endPoint.getAnchoringRO();
                if (anchoringPoint == null) continue;
                IPMPlanElementRO planElement = anchoringPoint.getAnchoringDestination().getAnchoringFigure().getPlanElementRO();
                if (outgoingPlanElement == null) {
                    outgoingPlanElement = planElement;
                    continue;
                }
                if (planElement == null) continue;
                outgoingPlanElement.getType().equals(planElement.getType());
            }
            if (outgoingPlanElement != null && incomingPlanElement != null && outgoingPlanElement.getType().equals(incomingPlanElement.getType())) {
                return false;
            }
        } else if (numberOfOutgoingEdges == 1) {
            for (IAnchoring anchoring : anchorings) {
                IPMAnchoringPointRO anchoringPoint;
                IPMFigureRO controlFlow = anchoring.getAnchoringSource().getAnchoringFigure();
                IPMPointListRO controlFlowPointList = controlFlow.getPointListRO();
                IPMPointRO startPoint = controlFlowPointList.getPointRO(0);
                IPMPointRO endPoint = controlFlowPointList.getPointRO(controlFlowPointList.getPointCount() - 1);
                if (logicalOperator.getPlanElementRO().isOutgoingEdge(controlFlow)) {
                    anchoringPoint = endPoint.getAnchoringRO();
                    if (anchoringPoint == null) continue;
                    outgoingPlanElement = anchoringPoint.getAnchoringDestination().getAnchoringFigure().getPlanElementRO();
                    continue;
                }
                anchoringPoint = startPoint.getAnchoringRO();
                if (anchoringPoint == null) continue;
                IPMPlanElementRO planElement = anchoringPoint.getAnchoringDestination().getAnchoringFigure().getPlanElementRO();
                if (incomingPlanElement == null) {
                    incomingPlanElement = planElement;
                    continue;
                }
                if (planElement == null) continue;
                incomingPlanElement.getType().equals(planElement.getType());
            }
            if (outgoingPlanElement != null && incomingPlanElement != null && outgoingPlanElement.getType().equals(incomingPlanElement.getType())) {
                return false;
            }
        }
        return true;
    }

    private static boolean isEventLogicalOperatorCombinationValid(IPMFigureRO eventFigure, IPMFigureRO logicalOperator) {
        boolean isValid = true;
        IPMPlanElementRO logicalOperatorPE = logicalOperator.getPlanElementRO();
        return isValid;
    }

    private static boolean isRelation(IPMFigureRO figure) {
        boolean isControlFlow = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isControlFlow |= planElement instanceof IPMPlanElementBPMNBPDRelationRO;
    }

    private static boolean isEvent(IPMFigureRO figure, boolean isCenterDotValid) {
        boolean isEvent = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPMNBPDEventRO) {
            IPMPlanElementBPMNBPDEventRO event = (IPMPlanElementBPMNBPDEventRO)planElement;
            isEvent |= event.getOutlineFigureRO() == figure || isCenterDotValid && event.getCenterPointFigureRO() == figure;
        }
        return isEvent;
    }

    private static boolean isDataObject(IPMFigureRO figure) {
        boolean isStorage = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPMNBPDDataObjectRO) {
            IPMPlanElementBPMNBPDDataObjectRO storage = (IPMPlanElementBPMNBPDDataObjectRO)planElement;
            isStorage |= storage.getOutlineFigureRO() == figure;
        }
        return isStorage;
    }

    private static boolean isDataObjectNew(IPMFigureRO figure) {
        boolean isStorage = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPMNBPDDataObjectNewRO) {
            IPMPlanElementBPMNBPDDataObjectNewRO storage = (IPMPlanElementBPMNBPDDataObjectNewRO)planElement;
            isStorage |= storage.getDataObjectFigureRO() == figure;
        }
        return isStorage;
    }

    private static boolean isMessage(IPMFigureRO figure) {
        boolean isMessage = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPMNBPDMessageRO) {
            IPMPlanElementBPMNBPDMessageRO message = (IPMPlanElementBPMNBPDMessageRO)planElement;
            isMessage |= message.getOutlineFigureRO() == figure;
        }
        return isMessage;
    }

    private static boolean isActivity(IPMFigureRO figure) {
        boolean isFunction = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPMNBPDActivityRO) {
            IPMPlanElementBPMNBPDActivityRO function = (IPMPlanElementBPMNBPDActivityRO)planElement;
            isFunction |= function.getOutlineFigureRO() == figure;
        }
        return isFunction;
    }

    private static boolean isCompetency(IPMFigureRO figure) {
        boolean isFunction = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPMNBPDCompetencyRO) {
            IPMPlanElementBPMNBPDCompetencyRO function = (IPMPlanElementBPMNBPDCompetencyRO)planElement;
            isFunction |= function.getOutlineFigureRO() == figure;
        }
        return isFunction;
    }

    private static boolean isGateway(IPMFigureRO figure) {
        boolean isLogicalOperator = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementBPMNBPDGatewayRO) {
            IPMPlanElementBPMNBPDGatewayRO logicalOperator = (IPMPlanElementBPMNBPDGatewayRO)planElement;
            isLogicalOperator |= logicalOperator.getGatewayFigureRO() == figure;
        }
        return isLogicalOperator;
    }

    private static boolean isDotsComment(IPMFigureRO figure) {
        boolean isComment = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isComment |= planElement instanceof IPMPlanElementDotsCommentRO;
    }
}

