/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.PATCHED_ScrollingGraphicalViewer;
import com.arcway.planagent.planeditor.PlanEditorEditDomain;
import com.arcway.planagent.planeditor.commands.RQMove;
import com.arcway.planagent.planeditor.edit.EditMgr;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.SelectionManager;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEKeyDown;
import com.arcway.planagent.planeditor.tools.InputEvent;
import java.util.List;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Cursor;

public class IPArrowMove
extends AbstractInputProcessor {
    private static final ILogger logger = Logger.getLogger(IPArrowMove.class);
    private Request request;
    private final SelectionManager selectionManager;
    private static final int PIXELS_TO_MOVE = 5;

    public IPArrowMove(GenericTool tool, SelectionManager selectionManager) {
        super(tool);
        this.selectionManager = selectionManager;
        this.request = new Request();
        this.request.setType((Object)"move children");
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    @Override
    public int handleEvent(InputEvent event) {
        boolean moveChildren = this.getTool().getState().isShiftKeyDown();
        if (event instanceof IEKeyDown) {
            IEKeyDown keyEvent = (IEKeyDown)event;
            int pixelsToMove = 5;
            EditPartViewer viewer = this.getTool().getCurrentViewer();
            if (viewer != null && viewer instanceof PATCHED_ScrollingGraphicalViewer) {
                PATCHED_ScrollingGraphicalViewer fmcaViewer = (PATCHED_ScrollingGraphicalViewer)viewer;
                EditDomain editDomain = this.getTool().getCurrentViewer().getEditDomain();
                if (editDomain != null && editDomain instanceof PlanEditorEditDomain) {
                    PlanEditorEditDomain planEditorEditDomain = (PlanEditorEditDomain)editDomain;
                    double gridSizeX = planEditorEditDomain.getGrid().getGridSpacingX();
                    double gridSizeY = planEditorEditDomain.getGrid().getGridSpacingY();
                    RootEditPart rootEditPart = fmcaViewer.getRootEditPart();
                    EditMgr editMgr = fmcaViewer.getEditMgr();
                    if (rootEditPart != null && editMgr != null) {
                        Point origin = editMgr.transformPlanToWindowCoordinates(Point.ORIGIN, rootEditPart, false);
                        Point dest = editMgr.transformPlanToWindowCoordinates(new Point(gridSizeX, gridSizeY), rootEditPart, false);
                        GeoVector distance = new GeoVector(origin, dest);
                        int maxGridDistanceInPixels = (int)Math.ceil(Math.max(Math.abs(distance.x), Math.abs(distance.y)) * 5.0 / 8.0 + 1.0E-10);
                        pixelsToMove = Math.max(pixelsToMove, maxGridDistanceInPixels);
                    }
                }
            }
            if (keyEvent.getPressedKey().keyCode == 0x1000003) {
                this.handleMove(-pixelsToMove, 0, moveChildren);
                return 1;
            }
            if (keyEvent.getPressedKey().keyCode == 0x1000004) {
                this.handleMove(pixelsToMove, 0, moveChildren);
                return 1;
            }
            if (keyEvent.getPressedKey().keyCode == 0x1000001) {
                this.handleMove(0, -pixelsToMove, moveChildren);
                return 1;
            }
            if (keyEvent.getPressedKey().keyCode == 0x1000002) {
                this.handleMove(0, pixelsToMove, moveChildren);
                return 1;
            }
        }
        return 0;
    }

    private void handleMove(int x, int y, boolean moveChildrenToo) {
        PEPlan plan = (PEPlan)this.getTool().getCurrentViewer().getContents();
        List items = this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer());
        if (logger.isDebugEnabled(74)) {
            logger.debug(74, "move items by arrow key - items = " + items);
        }
        this.request = new RQMove(x, y, items, moveChildrenToo, false);
        Command command = plan.getCommand(this.getRequest());
        this.executeCommand(command);
    }

    @Override
    public void cancel() {
    }

    @Override
    public Cursor getCursor() {
        return null;
    }
}

