/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.handles;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.Utilities;
import com.arcway.planagent.planeditor.handles.HandleLineLocator;
import com.arcway.planagent.planeditor.handles.HandleOutlineLocator;
import com.arcway.planagent.planeditor.handles.HandlePointLocator;
import com.arcway.planagent.planeditor.handles.IHandleFigureConstructionKit;
import com.arcway.planagent.planeditor.handles.IHandleLine;
import com.arcway.planagent.planeditor.handles.IHandleOutline;
import com.arcway.planagent.planeditor.handles.IHandlePoint;
import com.arcway.planagent.planeditor.handles.IHandlePointWithImageAndToolTip;
import com.arcway.planagent.planeditor.handles.IHandleProvider;
import com.arcway.planagent.planeditor.handles.PFHandleFigure;
import com.arcway.planagent.planeditor.handles.PVHandleView;
import com.arcway.planagent.planeditor.handles.PVHandleViewColoredDiamond;
import com.arcway.planagent.planeditor.handles.PVHandleViewColoredLine;
import com.arcway.planagent.planeditor.handles.PVHandleViewColoredOutline;
import com.arcway.planagent.planeditor.handles.PVHandleViewColoredRectangle;
import com.arcway.planagent.planeditor.handles.PVHandleViewImage;
import com.arcway.planagent.planeditor.handles.TransformingHandleLocator;
import com.arcway.planagent.planeditor.tools.Cursors;
import com.arcway.planagent.planview.view.IViewPartMgr;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;

public class DefaultHandleFigureConstructionKit
implements IHandleFigureConstructionKit {
    private static final ILogger logger = Logger.getLogger(DefaultHandleFigureConstructionKit.class);
    private static final FillColor HANDLE_PLAN_ELEMENT_MAIN_FILL_COLOR = new FillColor(new Color(64, 128, 255));
    private static final Color HANDLE_PLAN_ELEMENT_MAIN_BORDER_COLOR = new Color(64, 128, 255);
    private static final LineStyle HANDLE_PLAN_ELEMENT_MAIN_BORDER_STYLE = LineStyle.DASHSHORT;
    private static final FillColor HANDLE_PLAN_ELEMENT_SPECIAL_FILL_COLOR = new FillColor(Color.YELLOW);
    private static final Color HANDLE_PLAN_ELEMENT_SPECIAL_BORDER_COLOR = Color.BLACK;
    private static final LineStyle HANDLE_PLAN_ELEMENT_SPECIAL_BORDER_STYLE = LineStyle.DASHSHORT;
    private static final FillColor HANDLE_FIGURE_MAIN_FILL_COLOR = new FillColor(Color.DARKGREEN);
    private static final Color HANDLE_FIGURE_MAIN_BORDER_COLOR = Color.DARKGREEN;
    private static final LineStyle HANDLE_FIGURE_MAIN_BORDER_STYLE = LineStyle.SOLID;
    private static final FillColor HANDLE_FIGURE_SPECIAL_FILL_COLOR = new FillColor(Color.ORANGE);
    private static final Color HANDLE_FIGURE_SPECIAL_BORDER_COLOR = Color.YELLOW;
    private static final LineStyle HANDLE_FIGURE_SPECIAL_BORDER_STYLE = LineStyle.DASHSHORT;
    private static final FillColor HANDLE_GRAPHICAL_SUPPLEMENT_MAIN_FILL_COLOR = new FillColor(Color.ORANGE);
    private static final Color HANDLE_GRAPHICAL_SUPPLEMENT_MAIN_BORDER_COLOR = Color.ORANGE;
    private static final LineStyle HANDLE_GRAPHICAL_SUPPLEMENT_MAIN_BORDER_STYLE = LineStyle.DASH;
    private static final FillColor HANDLE_GRAPHICAL_SUPPLEMENT_SPECIAL_FILL_COLOR = new FillColor(Color.YELLOW);
    private static final Color HANDLE_GRAPHICAL_SUPPLEMENT_SPECIAL_BORDER_COLOR = Color.BLACK;
    private static final LineStyle HANDLE_GRAPHICAL_SUPPLEMENT_SPECIAL_BORDER_STYLE = LineStyle.DOT;

    @Override
    public List createHandleFigures(PEPlanEditPart planEditPart, IViewPartMgr viewPartMgr) {
        PFHandleFigure handleFigure;
        PVHandleView handleView;
        TransformingHandleLocator locator;
        assert (planEditPart != null) : "planEditPart is null";
        assert (viewPartMgr != null) : "viewPartMgr != null";
        IHandleProvider handleProvider = planEditPart.getHandleProvider();
        assert (handleProvider != null);
        List<IHandlePoint> pointHandles = handleProvider.getPointHandles();
        List<IHandleLine> lineHandles = handleProvider.getLineHandles();
        List<IHandleOutline> outlineHandles = handleProvider.getOutlineHandles();
        ArrayList<PFHandleFigure> handleFigures = new ArrayList<PFHandleFigure>(pointHandles.size() + lineHandles.size() + outlineHandles.size());
        int outlineIndex = 0;
        while (outlineIndex < outlineHandles.size()) {
            IHandleOutline handleOutline = outlineHandles.get(outlineIndex);
            locator = new HandleOutlineLocator(viewPartMgr, planEditPart.getPFPlan(), handleOutline.getPosition());
            handleView = handleOutline.getType() == 1 ? new PVHandleViewColoredOutline(locator, handleOutline.isClosedDraw(), 1.0, this.getBorderColorMain(planEditPart), this.getBorderStyleMain(planEditPart)) : new PVHandleViewColoredOutline(locator, handleOutline.isClosedDraw(), 1.0, this.getBorderColorSpecial(planEditPart), this.getBorderStyleSpecial(planEditPart));
            handleFigure = new PFHandleFigure(handleOutline, handleView, planEditPart.getFigure());
            handleFigures.add(handleFigure);
            ++outlineIndex;
        }
        int lineIndex = 0;
        while (lineIndex < lineHandles.size()) {
            IHandleLine handleLine = lineHandles.get(lineIndex);
            locator = new HandleLineLocator(viewPartMgr, planEditPart.getPFPlan(), handleLine.getLine());
            handleView = handleLine.getType() == 1 ? new PVHandleViewColoredRectangle(locator, 8.0, 8.0, 1.0, Color.WHITE, LineStyle.SOLID, this.getFillColorMain(planEditPart), FillStyle.SOLID) : new PVHandleViewColoredRectangle(locator, 8.0, 8.0, 1.0, Color.WHITE, LineStyle.SOLID, this.getFillColorSpecial(planEditPart), FillStyle.SOLID);
            handleFigure = new PFHandleFigure(handleLine, handleView, planEditPart.getFigure());
            handleFigures.add(handleFigure);
            ++lineIndex;
        }
        int pointIndex = 0;
        while (pointIndex < pointHandles.size()) {
            PVHandleView handleView2;
            double width;
            IHandlePoint handlePoint = pointHandles.get(pointIndex);
            GeoVector dir = handlePoint.getDirection();
            HandlePointLocator locator2 = new HandlePointLocator(viewPartMgr, planEditPart.getPFPlan(), handlePoint.getPosition(), handlePoint.getOffsetInPixels(), dir);
            if (dir == null) {
                width = 8.0;
                double height = 8.0;
                if (handlePoint.getType() == 1) {
                    handleView2 = new PVHandleViewColoredRectangle(locator2, width, height, 1.0, Color.WHITE, LineStyle.SOLID, this.getFillColorMain(planEditPart), FillStyle.SOLID);
                } else if (handlePoint.getType() == 2) {
                    handleView2 = new PVHandleViewColoredDiamond(locator2, width, height, 1.0, this.getBorderColorSpecial(planEditPart), LineStyle.SOLID, this.getFillColorSpecial(planEditPart), FillStyle.SOLID);
                } else {
                    IHandlePointWithImageAndToolTip handlePointWithImageAndToolTip = (IHandlePointWithImageAndToolTip)handlePoint;
                    handleView2 = new PVHandleViewImage(locator2, handlePointWithImageAndToolTip.getImage());
                }
            } else {
                width = 2.1;
                double length = 10.0;
                handleView2 = handlePoint.getType() == 1 ? new PVHandleViewColoredLine(locator2, width, length, this.getFillColorMain(planEditPart), FillStyle.SOLID) : new PVHandleViewColoredLine(locator2, width, length, this.getFillColorSpecial(planEditPart), FillStyle.SOLID);
            }
            PFHandleFigure handleFigure2 = new PFHandleFigure(handlePoint, handleView2, planEditPart.getFigure());
            if (dir == null && handlePoint.getType() == 3) {
                IHandlePointWithImageAndToolTip handlePointWithImageAndToolTip = (IHandlePointWithImageAndToolTip)handlePoint;
                handleFigure2.setToolTip((IFigure)handlePointWithImageAndToolTip.getToolTip());
                handleFigure2.setCursor(Cursors.ADDARROW);
            }
            handleFigures.add(handleFigure2);
            ++pointIndex;
        }
        return handleFigures;
    }

    private FillColor getFillColorMain(PEPlanEditPart planEditPart) {
        switch (Utilities.getLevelOfEditPart((EditPart)planEditPart)) {
            case 0: {
                return null;
            }
            case 1: {
                return HANDLE_PLAN_ELEMENT_MAIN_FILL_COLOR;
            }
            case 2: {
                return HANDLE_FIGURE_MAIN_FILL_COLOR;
            }
            case 3: {
                return HANDLE_GRAPHICAL_SUPPLEMENT_MAIN_FILL_COLOR;
            }
        }
        assert (false) : "unknown level of planEditPart";
        logger.warn("unknown level of planEditPart = " + planEditPart);
        return null;
    }

    private FillColor getFillColorSpecial(PEPlanEditPart planEditPart) {
        switch (Utilities.getLevelOfEditPart((EditPart)planEditPart)) {
            case 0: {
                return null;
            }
            case 1: {
                return HANDLE_PLAN_ELEMENT_SPECIAL_FILL_COLOR;
            }
            case 2: {
                return HANDLE_FIGURE_SPECIAL_FILL_COLOR;
            }
            case 3: {
                return HANDLE_GRAPHICAL_SUPPLEMENT_SPECIAL_FILL_COLOR;
            }
        }
        assert (false) : "unknown level of planEditPart";
        logger.warn("unknown level of planEditPart = " + planEditPart);
        return null;
    }

    private Color getBorderColorMain(PEPlanEditPart planEditPart) {
        switch (Utilities.getLevelOfEditPart((EditPart)planEditPart)) {
            case 0: {
                return null;
            }
            case 1: {
                return HANDLE_PLAN_ELEMENT_MAIN_BORDER_COLOR;
            }
            case 2: {
                return HANDLE_FIGURE_MAIN_BORDER_COLOR;
            }
            case 3: {
                return HANDLE_GRAPHICAL_SUPPLEMENT_MAIN_BORDER_COLOR;
            }
        }
        assert (false) : "unknown level of planEditPart";
        logger.warn("unknown level of planEditPart = " + planEditPart);
        return null;
    }

    private Color getBorderColorSpecial(PEPlanEditPart planEditPart) {
        switch (Utilities.getLevelOfEditPart((EditPart)planEditPart)) {
            case 0: {
                return null;
            }
            case 1: {
                return HANDLE_PLAN_ELEMENT_SPECIAL_BORDER_COLOR;
            }
            case 2: {
                return HANDLE_FIGURE_SPECIAL_BORDER_COLOR;
            }
            case 3: {
                return HANDLE_GRAPHICAL_SUPPLEMENT_SPECIAL_BORDER_COLOR;
            }
        }
        assert (false) : "unknown level of planEditPart";
        logger.warn("unknown level of planEditPart = " + planEditPart);
        return null;
    }

    private LineStyle getBorderStyleMain(PEPlanEditPart planEditPart) {
        switch (Utilities.getLevelOfEditPart((EditPart)planEditPart)) {
            case 0: {
                return null;
            }
            case 1: {
                return HANDLE_PLAN_ELEMENT_MAIN_BORDER_STYLE;
            }
            case 2: {
                return HANDLE_FIGURE_MAIN_BORDER_STYLE;
            }
            case 3: {
                return HANDLE_GRAPHICAL_SUPPLEMENT_MAIN_BORDER_STYLE;
            }
        }
        assert (false) : "unknown level of planEditPart";
        logger.warn("unknown level of planEditPart = " + planEditPart);
        return null;
    }

    private LineStyle getBorderStyleSpecial(PEPlanEditPart planEditPart) {
        switch (Utilities.getLevelOfEditPart((EditPart)planEditPart)) {
            case 0: {
                return null;
            }
            case 1: {
                return HANDLE_PLAN_ELEMENT_SPECIAL_BORDER_STYLE;
            }
            case 2: {
                return HANDLE_FIGURE_SPECIAL_BORDER_STYLE;
            }
            case 3: {
                return HANDLE_GRAPHICAL_SUPPLEMENT_SPECIAL_BORDER_STYLE;
            }
        }
        assert (false) : "unknown level of planEditPart";
        logger.warn("unknown level of planEditPart = " + planEditPart);
        return null;
    }
}

