/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.figures;

import com.arcway.lib.geometry.Rectangle;
import com.arcway.planagent.planeditor.PlanEditorConstants;
import com.arcway.planagent.planeditor.figures.PFViewFigure;
import de.plans.lib.util.Logger;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.swt.graphics.Color;

public class PFPlan
extends FreeformLayer {
    private static final Logger logger = Logger.getLogger(PFPlan.class);
    private static Color DEFAULT_BACKGROUNDCOLOR_PROJECTOR = PlanEditorConstants.SWT_COLOR_ARCWAY_GOLD_BRIGHT;

    public PFPlan(int mode) {
        if (logger.isDebugEnabled(60)) {
            logger.debug(60, (Object)"Create PFPlan object");
        }
        this.setLayoutManager((LayoutManager)new FreeformLayout());
        switch (mode) {
            case 1: {
                this.setBorder((Border)new MarginBorder(500));
                this.setOpaque(false);
                break;
            }
            case 3: {
                this.setBorder((Border)new MarginBorder(20));
                this.setBackgroundColor(DEFAULT_BACKGROUNDCOLOR_PROJECTOR);
                this.setOpaque(true);
                break;
            }
            default: {
                logger.error((Object)("PFPlan(): illegal editor mode " + mode));
                this.setBorder((Border)new MarginBorder(20));
                this.setBackgroundColor(DEFAULT_BACKGROUNDCOLOR_PROJECTOR);
                this.setOpaque(true);
            }
        }
    }

    public Rectangle getContentSize() {
        Rectangle planContentBounds = null;
        for (IFigure contentFigure : this.getChildren()) {
            if (contentFigure instanceof PFViewFigure) {
                PFViewFigure viewFigure = (PFViewFigure)contentFigure;
                Rectangle childFigureBounds = viewFigure.getOuterBoundsInFigureCoordinates();
                if (planContentBounds == null) {
                    planContentBounds = new Rectangle(childFigureBounds);
                    continue;
                }
                planContentBounds = planContentBounds.union(childFigureBounds);
                continue;
            }
            logger.warn((Object)"PFPlan had a bastard child (which was not of type PFViewFigure)");
        }
        return planContentBounds;
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.fillRectangle(this.getBounds());
        }
    }
}

