/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.commands;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.commands.ICommandContext;
import com.arcway.planagent.planeditor.commands.SnappablePoint;
import com.arcway.planagent.planeditor.commands.TransactionCommand;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.transactions.TAMovePoint;
import com.arcway.planagent.planmodel.transactions.Transaction;
import java.util.Collection;

public class CMMovePoint
extends TransactionCommand {
    private static final ILogger logger = Logger.getLogger(CMMovePoint.class);
    private static final String COMMAND_LABEL = Messages.getString("CMMovePoint.Move_Point");

    public CMMovePoint(GeoVector transl, IPMPointRO point, ICommandContext commandContext) {
        super(commandContext);
        GeoVector translation = transl;
        if (logger.isTraceEnabled()) {
            logger.trace("CMMovePoint(GeoVector translation = " + translation + ", IPMPointRW point = " + point + ") - start");
        }
        assert (translation != null) : "translation is null";
        assert (point != null) : "point is null";
        Collection<SnappablePoint> points = SnappablePoint.gatherPoints(point);
        translation = commandContext.getGrid().snapPointTranslation(points, translation);
        TAMovePoint transaction = new TAMovePoint(point, this.getActionParameters(), translation);
        this.construct(COMMAND_LABEL, (Transaction)transaction);
        if (logger.isTraceEnabled()) {
            logger.trace("CMMovePoint(GeoVector, IPMPointRW) - end");
        }
    }
}

