/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planeditor.PlanEditorEditDomain;
import com.arcway.planagent.planeditor.actions.AbstractUIAction;
import com.arcway.planagent.planeditor.tools.IToolChangedListener;
import org.eclipse.gef.Tool;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractUIToolPaletteAction
extends AbstractUIAction
implements IToolChangedListener {
    private PlanEditorEditDomain activeEditDomain;
    private IPartListener partListener;
    private final IPartService partService;
    private final String id;

    public AbstractUIToolPaletteAction(IPartService service, String id) {
        super((IWorkbenchPart)((IWorkbenchPage)service).getActiveEditor());
        assert (id != null);
        this.partService = service;
        this.id = id;
        this.partListener = new IPartListener(){
            IEditorPart lastActiveEditor = null;

            public void partActivated(IWorkbenchPart part) {
                if (part instanceof IEditorPart) {
                    this.lastActiveEditor = (IEditorPart)part;
                    if (this.lastActiveEditor.getAdapter(PlanEditorEditDomain.class) != null) {
                        AbstractUIToolPaletteAction.this.setEditDomain((PlanEditorEditDomain)this.lastActiveEditor.getAdapter(PlanEditorEditDomain.class));
                    } else {
                        AbstractUIToolPaletteAction.this.setEditDomain(null);
                    }
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part == this.lastActiveEditor) {
                    AbstractUIToolPaletteAction.this.setEditDomain(null);
                }
            }

            public void partDeactivated(IWorkbenchPart p) {
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        this.partService.addPartListener(this.partListener);
    }

    protected boolean calculateEnabled() {
        this.setButtonState();
        return true;
    }

    protected void init() {
        this.setId(this.id);
        this.setButtonState();
    }

    public void run() {
        if (this.activeEditDomain != null) {
            if (this.getToolClass().isInstance(this.activeEditDomain.getActiveTool())) {
                if (this.activeEditDomain.getActiveTool() != this.activeEditDomain.getDefaultTool()) {
                    this.activeEditDomain.setActiveTool(this.activeEditDomain.getDefaultTool());
                    this.setChecked(false);
                }
            } else {
                this.activeEditDomain.setActiveTool(this.getTool());
                this.setChecked(true);
            }
        }
    }

    public Tool getDefaultTool() {
        Tool defaultTool = null;
        if (this.activeEditDomain != null) {
            defaultTool = this.activeEditDomain.getDefaultTool();
        }
        return defaultTool;
    }

    private void setButtonState() {
        if (this.activeEditDomain != null) {
            this.setChecked(this.getToolClass().isInstance(this.activeEditDomain.getActiveTool()));
        } else {
            this.setChecked(false);
        }
    }

    private void setEditDomain(PlanEditorEditDomain newEditDomain) {
        if (this.activeEditDomain == newEditDomain) {
            return;
        }
        if (this.activeEditDomain != null) {
            this.activeEditDomain.removeToolChangedListener(this);
        }
        this.activeEditDomain = newEditDomain;
        if (this.activeEditDomain != null) {
            this.activeEditDomain.addToolChangedListener(this);
        }
        this.refresh();
    }

    @Override
    public void toolChanged(Tool newTool) {
        this.setButtonState();
    }

    public void dispose() {
        if (this.partListener != null) {
            this.partService.removePartListener(this.partListener);
        }
        this.partListener = null;
    }

    public abstract Class<? extends Tool> getToolClass();

    public abstract Tool getTool();
}

