/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.actions;

import com.arcway.planagent.planmodel.access.readonly.IModelChangeRO;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeRootListener;
import com.arcway.planagent.planmodel.access.readonly.IModelChangeRootMgrRO;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractUIButton<SelectionInfoProviderType, ButtonDecoration>
extends Action
implements IPartListener,
ISelectionChangedListener,
IModelChangeRootListener {
    protected final IWorkbenchPage workbenchPage;
    protected final ButtonDecoration buttonType;
    protected ISelectionProvider registeredSelectionProvider = null;
    private Object state;
    private boolean refreshPending;
    private Set<Object> recentlySelectedStates = null;

    public AbstractUIButton(IWorkbenchPage workbenchPage, ButtonDecoration buttonType, int style, String menuText, Object initState) {
        super(menuText, style);
        assert (workbenchPage != null) : "workbenchPage is null";
        assert (buttonType != null) : "buttonType is null";
        this.workbenchPage = workbenchPage;
        this.buttonType = buttonType;
        this.setText(menuText);
        SelectionInfoProviderType currentSelectionInfo = this.getCurrentSelectionInfo();
        this.setState(currentSelectionInfo, initState);
        workbenchPage.addPartListener((IPartListener)this);
        this.registerToSelectionProvider();
        this.registerToModelChangeMgr();
        this.refresh(currentSelectionInfo);
        assert (!this.refreshPending);
    }

    public void dispose() {
        this.unregisterFromSelectionProvider();
        this.unregisterFromModelChangeMgr();
    }

    public void disposeUIAppearanceButton() {
        this.workbenchPage.removePartListener((IPartListener)this);
        this.unregisterFromModelChangeMgr();
        this.unregisterFromSelectionProvider();
    }

    public void aboutTofireModelChanges(Set<? extends IModelChangeRO> modelChanges) {
    }

    public final void modelChangesFired(Set<? extends IModelChangeRO> modelChanges) {
        assert (!this.refreshPending);
        SelectionInfoProviderType selectionInfoProvider = this.getCurrentSelectionInfo();
        if (this.getSelectedStates(selectionInfoProvider) != null) {
            if (!this.getSelectedStates(selectionInfoProvider).equals(this.recentlySelectedStates)) {
                this.updateStateFromSelection(selectionInfoProvider);
                this.recentlySelectedStates = this.getSelectedStates(selectionInfoProvider);
            }
        } else {
            this.updateStateFromSelection(selectionInfoProvider);
            this.recentlySelectedStates = null;
        }
        if (this.refreshPending) {
            this.refresh(selectionInfoProvider);
        }
        assert (!this.refreshPending);
    }

    protected abstract SelectionInfoProviderType createSelectionInfoProvider(ButtonDecoration var1, ISelection var2);

    protected abstract Set<Object> getSelectedStates(SelectionInfoProviderType var1);

    protected abstract boolean isEnabled(SelectionInfoProviderType var1, ButtonDecoration var2, Object var3);

    protected abstract ImageDescriptor getButtonImageDescriptor(ButtonDecoration var1, Object var2);

    protected abstract String getToolTipText(ButtonDecoration var1, Object var2);

    public void partActivated(IWorkbenchPart part) {
        this.registerToSelectionProvider();
        this.registerToModelChangeMgr();
        this.refresh(this.getCurrentSelectionInfo());
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.registerToSelectionProvider();
        this.registerToModelChangeMgr();
        this.refresh(this.getCurrentSelectionInfo());
    }

    public void partClosed(IWorkbenchPart part) {
        this.unregisterFromSelectionProvider();
        this.unregisterFromModelChangeMgr();
        this.refresh(this.getCurrentSelectionInfo());
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.unregisterFromSelectionProvider();
        this.unregisterFromModelChangeMgr();
        this.refresh(this.getCurrentSelectionInfo());
    }

    public void partOpened(IWorkbenchPart part) {
        this.registerToSelectionProvider();
        this.registerToModelChangeMgr();
        this.refresh(this.getCurrentSelectionInfo());
    }

    public final void run() {
        assert (!this.refreshPending);
        this.apply();
        SelectionInfoProviderType selectionInfoProvider = this.getCurrentSelectionInfo();
        this.updateStateFromSelection(selectionInfoProvider);
        this.refresh(selectionInfoProvider);
        assert (!this.refreshPending);
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        assert (!this.refreshPending);
        this.refreshPending = true;
        SelectionInfoProviderType selectionInfoProvider = this.getCurrentSelectionInfo();
        this.selectionChanged(selectionInfoProvider);
        assert (!this.refreshPending);
    }

    public void selectionChanged(SelectionInfoProviderType selectionInfoProvider) {
        this.updateStateFromSelection(selectionInfoProvider);
        this.refresh(selectionInfoProvider);
    }

    protected SelectionInfoProviderType getCurrentSelectionInfo() {
        ISelection currentSelection = null;
        ISelectionProvider selectionProvider = this.getCurrentSelectionProvider();
        if (selectionProvider != null) {
            currentSelection = selectionProvider.getSelection();
        }
        return this.createSelectionInfoProvider(this.buttonType, currentSelection);
    }

    protected void refresh(SelectionInfoProviderType selectionInfoProvider) {
        boolean enabled = this.isEnabled(selectionInfoProvider, this.buttonType, this.state);
        this.setEnabled(enabled);
        this.recentlySelectedStates = this.getSelectedStates(selectionInfoProvider);
        this.refreshPending = false;
    }

    protected Object getState() {
        return this.state;
    }

    protected void setState(SelectionInfoProviderType selectionInfoProvider, Object state) {
        assert (selectionInfoProvider != null);
        this.state = state;
        this.setImageDescriptor(this.getButtonImageDescriptor(this.buttonType, state));
        this.setHoverImageDescriptor(this.getButtonImageDescriptor(this.buttonType, state));
        this.setToolTipText(this.getToolTipText(this.buttonType, state));
        this.setEnabled(false);
        this.setEnabled(true);
        this.refreshPending = true;
    }

    protected void updateStateFromSelection(SelectionInfoProviderType selectionInfoProvider) {
        assert (selectionInfoProvider != null);
    }

    protected void apply() {
        SelectionInfoProviderType selectionInfo = this.getCurrentSelectionInfo();
        this.apply(selectionInfo, this.buttonType, this.state);
    }

    protected abstract void apply(SelectionInfoProviderType var1, ButtonDecoration var2, Object var3);

    private IEditorPart getActiveEditor() {
        return this.getPage().getActiveEditor();
    }

    private ISelectionProvider getCurrentSelectionProvider() {
        ISelectionProvider currentSelectionProvider = null;
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null) {
            currentSelectionProvider = activeEditor.getEditorSite().getSelectionProvider();
        }
        return currentSelectionProvider;
    }

    private IWorkbenchPage getPage() {
        return this.workbenchPage;
    }

    private void registerToModelChangeMgr() {
        PMPlan pmPlan;
        this.unregisterFromModelChangeMgr();
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null && (pmPlan = (PMPlan)activeEditor.getAdapter(PMPlan.class)) != null) {
            IModelChangeRootMgrRO modelChangeManager = pmPlan.getModelChangeRootMgrRO();
            modelChangeManager.addModelChangeRootListener((IModelChangeRootListener)this);
        }
    }

    private void registerToSelectionProvider() {
        this.unregisterFromSelectionProvider();
        ISelectionProvider newSelectionProvider = this.getCurrentSelectionProvider();
        if (newSelectionProvider != null) {
            newSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            this.registeredSelectionProvider = newSelectionProvider;
        }
    }

    private void unregisterFromModelChangeMgr() {
        PMPlan pmPlan;
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null && (pmPlan = (PMPlan)activeEditor.getAdapter(PMPlan.class)) != null) {
            IModelChangeRootMgrRO modelChangeManager = pmPlan.getModelChangeRootMgrRO();
            modelChangeManager.removeModelChangeRootListener((IModelChangeRootListener)this);
        }
    }

    private void unregisterFromSelectionProvider() {
        if (this.registeredSelectionProvider != null) {
            this.registeredSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.registeredSelectionProvider = null;
        }
    }
}

