/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.inputinterpreter;

import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.EXUnspecifiedImageLoadingError;
import com.arcway.lib.graphics.image.EXUnsupportedColorDepth;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.ImageFileType;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.resource.URLResource;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.planagent.planeditor.cm.Messages;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.inputinterpreter.IInputContext;
import com.arcway.planagent.planmodel.FMCAPlanModelCommonPlugin;
import de.plans.lib.eclipse.ResourceLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractImageSupplementEditPolicy
extends AbstractEditPolicy {
    static final IStreamResource ERROR_IMAGE;

    static {
        try {
            URL url = ResourceLoader.getUrl((Plugin)FMCAPlanModelCommonPlugin.getDefault(), (String)"icons/missingImg.png");
            URLResource streamResource = new URLResource(url);
            byte[] pngOrJpgByteArray = ImageCoDec.loadIntoPNGOrJPGByteArray((IStreamResource)streamResource);
            File tmpFile = SessionTempDirectoryManager.createSessionTempFile((String)"planeditorimage", (String)ImageCoDec.determineFileType((IStreamResource)streamResource).getFileExtension());
            FileOutputStream os = new FileOutputStream(tmpFile);
            os.write(pngOrJpgByteArray);
            os.close();
            ERROR_IMAGE = new FileResource(tmpFile);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    protected IStreamResource loadIntoTempFile(IStreamResource streamResource) {
        Image image = null;
        try {
            image = ImageCoDec.decodeIntoImage((IStreamResource)streamResource);
            int w = image.getWidthInPixels();
            int h = image.getHeightInPixels();
            if ((long)(w * h) > 3048192L) {
                Image scaledImage = Image.scaleImage((Image)image, (long)3048192L);
                image.dispose();
                image = scaledImage;
            }
            File tmpFile = SessionTempDirectoryManager.createSessionTempFile((String)"planeditorimage", null);
            ImageCoDec.encodeIntoFile((Image)image, (File)tmpFile, (ImageFileType)ImageCoDec.PNG);
            FileResource pngByteArrayAsStreamResource = new FileResource(tmpFile);
            return pngByteArrayAsStreamResource;
        }
        catch (EXImageDataTypeNotSupported e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXImageDataTypeNotSupported_Cause"));
            return ERROR_IMAGE;
        }
        catch (EXUnsupportedColorDepth e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXUnsupportedColorDepth_Cause"));
            return ERROR_IMAGE;
        }
        catch (EXNoMoreHandles e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXNoMoreHandles_Cause"));
            return ERROR_IMAGE;
        }
        catch (EXCorruptImageFileContent e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXCorruptImageFileContent_Cause"));
            return ERROR_IMAGE;
        }
        catch (JvmExternalResourceInteractionException e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.JvmExternalResourceIneractionException_Cause"));
            return ERROR_IMAGE;
        }
        catch (EXUnspecifiedImageLoadingError e) {
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXUnspecifiedImageLoadingError_Cause"));
            return ERROR_IMAGE;
        }
        catch (EXImageTooBig e) {
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
            this.openErrorDialog(Messages.getString("AbstractImageSupplementEditPolicy.EXImageTooBig_Cause"));
            return ERROR_IMAGE;
        }
    }

    private void openErrorDialog(final String descriptionOfCause) {
        IModificationProblem problem = new IModificationProblem(){

            public String getHumanReadableDescriptionOfCause() {
                return descriptionOfCause;
            }

            public String getHumanReadableDescriptionOfConsequence() {
                return Messages.getString("AbstractImageSupplementEditPolicy.GeneralErrorDescription");
            }

            public int getSeverity() {
                return 2;
            }
        };
        IInputContext inputContext = ((PEPlanEditPart)this.getHost()).getPEPlan().getInputContext();
        Shell shell = inputContext.getShell();
        Set<1> modificationProblems = Collections.singleton(problem);
        ModificationProblemsDialog dialog = new ModificationProblemsDialog(modificationProblems, shell);
        dialog.open();
    }
}

