/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.cm.actions;

import com.arcway.lib.geometry.Direction;
import com.arcway.planagent.planeditor.FMCAPlanEditorCommonPlugin;
import com.arcway.planagent.planeditor.actions.IAppearanceButtonDecorationWithMenu;
import com.arcway.planagent.planeditor.cm.Messages;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.TextAppearanceTpl;
import de.plans.lib.eclipse.ResourceLoader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;

public class TextAngleDecoration
implements IAppearanceButtonDecorationWithMenu {
    private static final String[] descriptions = new String[]{Messages.getString("TextAngleDecoration.0"), Messages.getString("TextAngleDecoration.30"), Messages.getString("TextAngleDecoration.45"), Messages.getString("TextAngleDecoration.60"), Messages.getString("TextAngleDecoration.90")};
    private static final ImageDescriptor[] imagesDescriptors = new ImageDescriptor[]{TextAngleDecoration.createImageDescriptor(0), TextAngleDecoration.createImageDescriptor(30), TextAngleDecoration.createImageDescriptor(45), TextAngleDecoration.createImageDescriptor(60), TextAngleDecoration.createImageDescriptor(90)};
    private static TextAngleDecoration singelton;

    private static String getDescription(int angle) {
        return descriptions[TextAngleDecoration.getIndex(angle)];
    }

    private static ImageDescriptor getImageDescriptor(int angle) {
        return imagesDescriptors[TextAngleDecoration.getIndex(angle)];
    }

    private static int getIndex(int angle) {
        int i;
        switch (angle) {
            case 30: {
                i = 1;
                break;
            }
            case 45: {
                i = 2;
                break;
            }
            case 60: {
                i = 3;
                break;
            }
            case 90: {
                i = 4;
                break;
            }
            default: {
                i = 0;
            }
        }
        return i;
    }

    private static ImageDescriptor createImageDescriptor(int angle) {
        ImageDescriptor descriptor = ResourceLoader.getImageDescriptor((String)("cm/" + TextAngleDecoration.getImageFileName(angle)), (Plugin)FMCAPlanEditorCommonPlugin.getDefault());
        return descriptor;
    }

    private static String getImageFileName(int angle) {
        return "textangle_" + angle + ".gif";
    }

    private static int toAngle(Object state) {
        Integer i = (Integer)state;
        int angle = i != null ? i : 0;
        return angle;
    }

    private static ITextAppearanceTpl toTemplate(int angle) {
        TextAppearanceTpl template = new TextAppearanceTpl();
        template.setDirection(Direction.valueOf((double)angle));
        return template;
    }

    private TextAngleDecoration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextAngleDecoration getInstance() {
        Class<TextAngleDecoration> clazz = TextAngleDecoration.class;
        synchronized (TextAngleDecoration.class) {
            if (singelton == null) {
                singelton = new TextAngleDecoration();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singelton;
        }
    }

    public Class[] getAppearanceClasses() {
        return new Class[]{ITextAppearanceRO.class};
    }

    public Object getStateOfAppearance(IAppearanceRO appearance) {
        return ((ITextAppearanceRO)appearance).getDirection().toInteger();
    }

    public String getToolTipText(Object state) {
        return TextAngleDecoration.getDescription(TextAngleDecoration.toAngle(state));
    }

    public ImageDescriptor getButtonImageDescriptor(Object state) {
        return TextAngleDecoration.getImageDescriptor(TextAngleDecoration.toAngle(state));
    }

    public ImageDescriptor getMenuEntryImage(Object state) {
        return TextAngleDecoration.getImageDescriptor(TextAngleDecoration.toAngle(state));
    }

    public String getMenuEntryText(Object state) {
        return TextAngleDecoration.getDescription(TextAngleDecoration.toAngle(state));
    }

    public IAppearanceTpl[] getAppearanceTemplates(Object state) {
        return new IAppearanceTpl[]{TextAngleDecoration.toTemplate(TextAngleDecoration.toAngle(state))};
    }
}

