/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.controllinginterface.planviewer;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.lib.DTString;
import com.arcway.lib.codec.data.lib.generic.AbstractStructuredDataType;
import com.arcway.lib.java.collections.IList_;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planviewer.IProjection;
import com.arcway.planagent.controllinginterface.planviewer.IProjectionType;

public abstract class DTProjection
extends AbstractStructuredDataType {
    private static final IKey ROLE_PROJECTION_TYPE_ID = Key.getCanonicalKeyInstance((String)"projectionTypeID");
    private static final IKey ROLE_PROJECTION = Key.getCanonicalKeyInstance((String)"projection");
    private static DTProjection SINGELTON;

    public static synchronized DTProjection getInstance() {
        if (SINGELTON == null) {
            SINGELTON = new DTProjection(){

                @Override
                protected IProjection convertDataToTypedData(Object data) {
                    return (IProjection)data;
                }

                @Override
                protected Object convertTypedDataToData(IProjection typedData) throws EXDataCreationFailed {
                    return typedData;
                }
            };
        }
        return SINGELTON;
    }

    protected DTProjection() {
        this.addPropertyType(ROLE_PROJECTION_TYPE_ID, (IDataType)DTString.getInstance(), AbstractStructuredDataType.PropertyOrChildrenConstraint.MANDATORY_NOT_NULL);
        this.addPolymorphPropertyType(ROLE_PROJECTION, AbstractStructuredDataType.PropertyOrChildrenConstraint.MANDATORY_NOT_NULL);
    }

    protected abstract IProjection convertDataToTypedData(Object var1);

    protected abstract Object convertTypedDataToData(IProjection var1) throws EXDataCreationFailed;

    public boolean isNull(Object data) {
        IProjection typedData = this.convertDataToTypedData(data);
        return typedData == null;
    }

    public Object createNullDataElement() throws EXDataCreationFailed {
        IProjection typedData = null;
        Object data = this.convertTypedDataToData(typedData);
        return data;
    }

    public boolean isSet(Object data, IKey role) {
        throw new IllegalArgumentException();
    }

    protected IDataType getDataTypeOfPolymorphPropertyOrChildren(Object data, IKey role) {
        IProjection typedData = this.convertDataToTypedData(data);
        if (!IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROJECTION)) {
            throw new IllegalArgumentException();
        }
        String projectionTypeID = typedData.getProjectionTypeID();
        IDataType dataType = DTProjection.getProjectionDataType(projectionTypeID);
        return dataType;
    }

    private static IDataType getProjectionDataType(String projectionTypeID) {
        IProjectionType projectionType = PlanAgentExtensionMgr.getDefault().getProjectionType(projectionTypeID);
        IDataType dataType = projectionType.getProjectionDataType();
        return dataType;
    }

    public Object getProperty(Object data, IKey role) {
        Object propertyData;
        IProjection typedData = this.convertDataToTypedData(data);
        if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROJECTION_TYPE_ID)) {
            propertyData = typedData.getProjectionTypeID();
        } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROJECTION)) {
            propertyData = typedData;
        } else {
            throw new IllegalArgumentException();
        }
        return propertyData;
    }

    public IList_<Object> getChildren(Object data, IKey role) {
        throw new IllegalArgumentException();
    }

    public AbstractStructuredDataType.AbstractStructuredDataFactory createStructuredDataFactory() {
        return new DataFactory();
    }

    private class DataFactory
    extends AbstractStructuredDataType.AbstractStructuredDataFactory {
        private String projectionTypeID = null;
        private IProjection projection = null;

        private DataFactory() {
        }

        public void setFlag(IKey role) {
            throw new IllegalArgumentException();
        }

        public IDataType getDataTypeOfPolymorphPropertyOrChildren(IKey role) {
            if (!IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROJECTION)) {
                throw new IllegalArgumentException();
            }
            IDataType dataType = DTProjection.getProjectionDataType(this.projectionTypeID);
            return dataType;
        }

        public void addPropertyOrChild(IKey role, Object propertyOrChild) {
            if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROJECTION_TYPE_ID)) {
                this.projectionTypeID = (String)propertyOrChild;
            } else if (IKey.IS_EQUAL_IKEY_HASHER.isEqual((Object)role, (Object)ROLE_PROJECTION)) {
                this.projection = (IProjection)propertyOrChild;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public Object createDataElement() throws EXDataCreationFailed {
            Object data = DTProjection.this.convertTypedDataToData(this.projection);
            return data;
        }

        public boolean isErroneousFlagOrPropertyOrChildToIgnore(IKey role, EXDataLoadingException exception) {
            return false;
        }
    }
}

