/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.data.lib;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.EXDataLoadingException;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.lib.generic.AbstractStructuredDataType;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public abstract class DTFlags
extends AbstractStructuredDataType {
    private static final ILogger LOGGER = Logger.getLogger(DTFlags.class);
    private final boolean ignoreErroneousFlagsWhileLoading;

    public static DTFlags createInstance(IList_<String> flagNames, boolean ignoreErroneousFlagsWhileLoading) {
        DTFlags datatype = new DTFlags((IList_)flagNames, ignoreErroneousFlagsWhileLoading){

            @Override
            protected ISet_<String> convertDataToTypedData(Object data) {
                return (ISet_)data;
            }

            @Override
            protected Object convertTypedDataToData(ISet_<String> typedData) throws EXDataCreationFailed {
                return typedData;
            }

            @Override
            protected Object convertNullToData() throws EXDataCreationFailed {
                return null;
            }
        };
        return datatype;
    }

    protected DTFlags(IList_<String> flagNames, boolean ignoreErroneousFlagsWhileLoading) {
        for (String flagName : flagNames) {
            this.addFlagType(DTFlags.getKeyForFlagName(flagName));
        }
        this.ignoreErroneousFlagsWhileLoading = ignoreErroneousFlagsWhileLoading;
    }

    private static IKey getKeyForFlagName(String flagName) {
        return Key.getCanonicalKeyInstance(flagName);
    }

    protected abstract ISet_<String> convertDataToTypedData(Object var1);

    protected abstract Object convertTypedDataToData(ISet_<String> var1) throws EXDataCreationFailed;

    protected abstract Object convertNullToData() throws EXDataCreationFailed;

    @Override
    public boolean isNull(Object data) {
        ISet_<String> typedData = this.convertDataToTypedData(data);
        return typedData == null;
    }

    @Override
    public Object createNullDataElement() throws EXDataCreationFailed {
        Object data = this.convertNullToData();
        return data;
    }

    @Override
    public boolean isSet(Object data, IKey role) {
        ISet_<String> typedData = this.convertDataToTypedData(data);
        boolean isSet = typedData.contains(role.toCanonicalString());
        return isSet;
    }

    @Override
    public Object getProperty(Object data, IKey role) {
        throw new IllegalArgumentException();
    }

    public IList_<Object> getChildren(Object data, IKey role) {
        throw new IllegalArgumentException();
    }

    @Override
    public AbstractStructuredDataType.AbstractStructuredDataFactory createStructuredDataFactory() {
        return new DataFactory();
    }

    private class DataFactory
    extends AbstractStructuredDataType.AbstractStructuredDataFactory {
        private final ISetRW_<String> flags = new HashSet_<Object>(IHasher_.EQUALS_HASHER);

        private DataFactory() {
        }

        @Override
        public void setFlag(IKey role) {
            this.flags.add(role.toCanonicalString());
        }

        @Override
        public void addPropertyOrChild(IKey role, Object propertyOrChild) {
            throw new IllegalArgumentException();
        }

        @Override
        public Object createDataElement() throws EXDataCreationFailed {
            return DTFlags.this.convertTypedDataToData(this.flags);
        }

        @Override
        public boolean isErroneousFlagOrPropertyOrChildToIgnore(IKey role, EXDataLoadingException exception) {
            LOGGER.debug("Data decoding, erroneous flag: " + role.toCanonicalString());
            return DTFlags.this.ignoreErroneousFlagsWhileLoading;
        }
    }
}

