/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAnnotationImpl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XSDAttributeGroupTraverser
extends XSDAbstractTraverser {
    XSDAttributeGroupTraverser(XSDHandler xSDHandler, XSAttributeChecker xSAttributeChecker) {
        super(xSDHandler, xSAttributeChecker);
    }

    XSAttributeGroupDecl traverseLocal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, false, xSDocumentInfo);
        QName qName = (QName)objectArray[XSAttributeChecker.ATTIDX_REF];
        XSAttributeGroupDecl xSAttributeGroupDecl = null;
        if (qName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{"attributeGroup (local)", "ref"}, element);
            this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
            return null;
        }
        xSAttributeGroupDecl = (XSAttributeGroupDecl)this.fSchemaHandler.getGlobalDecl(xSDocumentInfo, 2, qName, element);
        Element element2 = DOMUtil.getFirstChildElement((Node)element);
        if (element2 != null) {
            Object[] objectArray2;
            String string = DOMUtil.getLocalName((Node)element2);
            if (string.equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
                element2 = DOMUtil.getNextSiblingElement((Node)element2);
            } else {
                objectArray2 = DOMUtil.getSyntheticAnnotation((Node)element2);
                if (objectArray2 != null) {
                    this.traverseSyntheticAnnotation(element2, (String)objectArray2, objectArray, false, xSDocumentInfo);
                }
            }
            if (element2 != null) {
                objectArray2 = new Object[]{qName.rawname, "(annotation?)", DOMUtil.getLocalName((Node)element2)};
                this.reportSchemaError("s4s-elt-must-match.1", objectArray2, element2);
            }
        }
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSAttributeGroupDecl;
    }

    XSAttributeGroupDecl traverseGlobal(Element element, XSDocumentInfo xSDocumentInfo, SchemaGrammar schemaGrammar) {
        XSObjectListImpl xSObjectListImpl;
        XSAttributeGroupDecl xSAttributeGroupDecl;
        Object object;
        XSAttributeGroupDecl xSAttributeGroupDecl2 = new XSAttributeGroupDecl();
        Object[] objectArray = this.fAttrChecker.checkAttributes(element, true, xSDocumentInfo);
        String string = (String)objectArray[XSAttributeChecker.ATTIDX_NAME];
        if (string == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{"attributeGroup (global)", "name"}, element);
            string = "no name";
        }
        xSAttributeGroupDecl2.fName = string;
        xSAttributeGroupDecl2.fTargetNamespace = xSDocumentInfo.fTargetNamespace;
        Element element2 = DOMUtil.getFirstChildElement((Node)element);
        XSAnnotationImpl xSAnnotationImpl = null;
        if (element2 != null && DOMUtil.getLocalName((Node)element2).equals(SchemaSymbols.ELT_ANNOTATION)) {
            xSAnnotationImpl = this.traverseAnnotationDecl(element2, objectArray, false, xSDocumentInfo);
            element2 = DOMUtil.getNextSiblingElement((Node)element2);
        } else {
            object = DOMUtil.getSyntheticAnnotation((Node)element);
            if (object != null) {
                xSAnnotationImpl = this.traverseSyntheticAnnotation(element, (String)object, objectArray, false, xSDocumentInfo);
            }
        }
        object = this.traverseAttrsAndAttrGrps(element2, xSAttributeGroupDecl2, xSDocumentInfo, schemaGrammar, null);
        if (object != null) {
            xSAttributeGroupDecl = new XSAttributeGroupDecl[]{string, "(annotation?, ((attribute | attributeGroup)*, anyAttribute?))", DOMUtil.getLocalName((Node)object)};
            this.reportSchemaError("s4s-elt-must-match.1", (Object[])xSAttributeGroupDecl, (Element)object);
        }
        xSAttributeGroupDecl2.removeProhibitedAttrs();
        xSAttributeGroupDecl = (XSAttributeGroupDecl)this.fSchemaHandler.getGrpOrAttrGrpRedefinedByRestriction(2, new QName(XMLSymbols.EMPTY_STRING, string, string, xSDocumentInfo.fTargetNamespace), xSDocumentInfo, element);
        if (xSAttributeGroupDecl != null && (xSObjectListImpl = xSAttributeGroupDecl2.validRestrictionOf(string, xSAttributeGroupDecl)) != null) {
            this.reportSchemaError((String)xSObjectListImpl[((XSObjectListImpl)xSObjectListImpl).length - 1], (Object[])xSObjectListImpl, element2);
            this.reportSchemaError("src-redefine.7.2.2", new Object[]{string, xSObjectListImpl[((XSObjectListImpl)xSObjectListImpl).length - 1]}, element2);
        }
        if (xSAnnotationImpl != null) {
            xSObjectListImpl = new XSObjectListImpl();
            xSObjectListImpl.add((XSObject)xSAnnotationImpl);
        } else {
            xSObjectListImpl = XSObjectListImpl.EMPTY_LIST;
        }
        xSAttributeGroupDecl2.fAnnotations = xSObjectListImpl;
        schemaGrammar.addGlobalAttributeGroupDecl(xSAttributeGroupDecl2);
        this.fAttrChecker.returnAttrArray(objectArray, xSDocumentInfo);
        return xSAttributeGroupDecl2;
    }
}

