/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import de.plans.lib.util.Notification;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EONotification
extends EOEncodableObject {
    public static final String XML_NAME = "Notification";
    private static final String ATTR_TAG_TYPE = "type";
    private String type;
    private EncodableObjectBase parameter = null;

    public EONotification(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EONotification(Notification n) {
        super(XML_NAME);
        this.type = n.getType();
        if (n.getParameter() instanceof EncodableObjectBase) {
            this.parameter = (EncodableObjectBase)n.getParameter();
        }
    }

    public EONotification(String type, EncodableObjectBase param) {
        super(XML_NAME);
        this.type = type;
        this.parameter = param;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_TYPE, this.type);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (name.equals(ATTR_TAG_TYPE)) {
            this.type = value;
            return true;
        }
        return false;
    }

    protected boolean hasChildren() {
        return this.parameter != null;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        if (this.parameter != null) {
            this.parameter.writeXMLBody(writeContext, depth);
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (this.parameter == null) {
            this.parameter = newChild;
            return true;
        }
        return false;
    }

    public Notification convertIntoNotification(String serverID) {
        return new Notification(this.type, serverID, (Object)this.parameter);
    }

    public String getType() {
        return this.type;
    }

    public EncodableObjectBase getParameter() {
        return this.parameter;
    }

    public void setType(String value) {
        this.type = value;
    }

    public void setParameter(EncodableObjectBase param) {
        this.parameter = param;
    }
}

