/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.eclipseplugin;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.PSCAbstractClientFactory;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.eclipseplugin.EclipseGUIFactory;
import de.plans.psc.client.eclipseplugin.EclipsePlugin;
import de.plans.psc.client.eclipseplugin.EclipsePluginExceptionDecoder;
import de.plans.psc.client.eclipseplugin.EclipsePluginMessageDataFactory;
import de.plans.psc.client.eclipseplugin.IWorkingDirectoryProvider;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class EclipsePluginClientFactory
extends PSCAbstractClientFactory {
    private static final ILogger logger = Logger.getLogger(EclipsePluginClientFactory.class);
    private PSCApplicationIdentifier applicationIdentifier = null;
    private File rootDir;
    private static final String CONFIGURATION_ELEMENT_NAME = "ApplicationAttributes";
    private static final String APPL_NAME_ATTRIBUTE = "ApplicationName";
    private static final String APPL_ID_ATTRIBUTE = "ApplicationID";
    private static final String APPL_VERSION_INFO = "Version";
    private static final String APPL_VERSION_FOR_SERVER_INFO = "VersionForServer";
    private static final String APPL_BUILD_INFO = "Build";
    private static final String APPL_ID_WORKING_DIR_PROVIDER = "WorkingDirectoryProvider";

    public EclipsePluginClientFactory() {
        super(new EclipseGUIFactory(), new EclipsePluginMessageDataFactory(), new EclipsePluginExceptionDecoder());
    }

    protected PSCClientServiceFacade setupClient() {
        PSCClientServiceFacade serviceFacade = this.setUpClient(this.getWorkingDirectory());
        return serviceFacade;
    }

    public static PSCAbstractClientFactory getClientFactory() {
        return cf;
    }

    @Override
    public void startAppl() {
    }

    @Override
    protected PSCApplicationIdentifier getApplicationIdentifier() {
        if (this.applicationIdentifier == null) {
            this.loadApplicationAttributes();
        }
        return this.applicationIdentifier;
    }

    protected File getWorkingDirectory() {
        if (this.rootDir == null) {
            this.loadApplicationAttributes();
            if (this.rootDir == null) {
                IPath path = EclipsePlugin.getDefault().getStateLocation();
                this.rootDir = path.toFile();
            }
            if (!this.rootDir.exists()) {
                this.rootDir.mkdirs();
            }
        }
        return this.rootDir;
    }

    @Override
    protected void createStaticApplObjects() {
    }

    @Override
    protected void constructApplClient() {
    }

    @Override
    protected void registerApplParameterSets() {
    }

    private void loadApplicationAttributes() {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        assert (registry != null) : "registry must not be null";
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.arcway.lib.psc.client", "application");
        assert (extensionPoint != null) : "extensionPoint must not be null";
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension currentExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                if (CONFIGURATION_ELEMENT_NAME.equals(currentConfigElement.getName())) {
                    String buildInfo;
                    String versionForServerInfo;
                    String versionInfo;
                    String applicationID;
                    String applicationName = currentConfigElement.getAttribute(APPL_NAME_ATTRIBUTE);
                    if (applicationName == null) {
                        applicationName = "PSCClient";
                    }
                    if ((applicationID = currentConfigElement.getAttribute(APPL_ID_ATTRIBUTE)) == null) {
                        applicationID = "PSCClt";
                    }
                    if ((versionInfo = currentConfigElement.getAttribute(APPL_VERSION_INFO)) == null) {
                        versionInfo = "[no version info]";
                    }
                    if ((versionForServerInfo = currentConfigElement.getAttribute(APPL_VERSION_FOR_SERVER_INFO)) == null) {
                        versionForServerInfo = "[no version for server info]";
                    }
                    if ((buildInfo = currentConfigElement.getAttribute(APPL_BUILD_INFO)) == null) {
                        buildInfo = "[no build info]";
                    }
                    this.applicationIdentifier = new PSCApplicationIdentifier(applicationID, applicationName, versionInfo, buildInfo, versionForServerInfo);
                    try {
                        Object o = currentConfigElement.createExecutableExtension(APPL_ID_WORKING_DIR_PROVIDER);
                        if (o instanceof IWorkingDirectoryProvider) {
                            this.rootDir = ((IWorkingDirectoryProvider)o).getWorkingDirectory();
                        }
                    }
                    catch (CoreException e) {
                        logger.error("Unable to load IWorkingDirectoryProvider", (Throwable)e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }
}

