/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.eclipseplugin;

import com.arcway.lib.eclipse.extensions.ExtensionMgr;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.psc.eclipse.client.update.updateurl.PSCClientUpdateURLHandler;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.dialogs.swt.LoggerPreferencePage;
import de.plans.psc.client.eclipseplugin.EclipsePluginClientFactory;
import de.plans.psc.client.eclipseplugin.ExceptionListener;
import de.plans.psc.client.eclipseplugin.IPSCStartupListener;
import de.plans.psc.client.eclipseplugin.MessageListener;
import de.plans.psc.client.eclipseplugin.PermissionTemplateExtensionsMgr;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.ServiceTracker;

public class EclipsePlugin
extends AbstractUIPlugin {
    private static final ILogger logger = Logger.getLogger(EclipsePlugin.class);
    private static EclipsePlugin plugin;
    private static BundleContext bundleContext;
    private boolean isPSCStartedUp = false;
    private ServiceTracker proxyServiceTracker;
    private EclipsePluginClientFactory clientFactory;
    private PSCClientServiceFacade clientServiceFacade;
    public static final String PSC_ECLIPSE_PLUGIN_ID = "com.arcway.lib.psc.client";
    public static final String FACTORY_EXTENSION_ID = "factories";
    public static final String PERMISSION_TEMPLATE_EXTENSION_ID = "serverPermissionTemplates";
    public static final String APPLICATION_ATTR_EXTENSION_ID = "application";

    public EclipsePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        bundleContext = context;
        this.proxyServiceTracker = new ServiceTracker(this.getBundle().getBundleContext(), IProxyService.class.getName(), null);
        this.proxyServiceTracker.open();
    }

    public void startupPSC() {
        if (!this.isPSCStartedUp) {
            this.clientFactory = new EclipsePluginClientFactory();
            this.clientServiceFacade = this.clientFactory.setupClient();
            new ExceptionListener();
            new MessageListener();
            LoggerPreferencePage.initLogger();
            Hashtable<String, String[]> properties = new Hashtable<String, String[]>(1);
            properties.put("url.handler.protocol", new String[]{"update"});
            bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new PSCClientUpdateURLHandler(), properties);
            PermissionTemplateExtensionsMgr.loadPermissionTemplates();
            this.isPSCStartedUp = true;
            List extensions = ExtensionMgr.getDefault().getExtension(PSC_ECLIPSE_PLUGIN_ID, "PSCStartupListener", "PSCStartupListener", "listener", IPSCStartupListener.class);
            for (IPSCStartupListener listener : extensions) {
                try {
                    listener.pscStartUpCompleted(this.clientServiceFacade);
                }
                catch (Exception e) {
                    logger.error("Informing a PSCStartupListener failed.", (Throwable)e);
                }
            }
        }
    }

    public BundleContext getBundleContext() {
        return bundleContext;
    }

    public static EclipsePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public EclipsePluginClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public PSCClientServiceFacade getClientServiceFacade() {
        if (this.clientServiceFacade == null) {
            this.startupPSC();
        }
        return this.clientServiceFacade;
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        String iconPath = "icons/";
        try {
            URL installURL = EclipsePlugin.getDefault().getBundle().getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + fileName);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("getImageDescriptor(String)" + e);
            }
            return null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.proxyServiceTracker.close();
        super.stop(context);
    }
}

