/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.IniFile;
import de.plans.lib.util.Notification;
import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.PSCClientLicenseInfo;
import de.plans.psc.client.PSCClientNotificationBus;
import de.plans.psc.client.ServerOperationsPermissionChecker;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.RequestForwarder;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOServerInfo;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PSCClientServiceFacade {
    private static final ILogger logger = Logger.getLogger(PSCClientServiceFacade.class);
    private static PSCClientServiceFacade singleton;
    private RequestForwarder requestForwarder;
    private File rootDir;
    private IniFile iniFileAgent = null;
    private final PSCClientNotificationBus notificationBus = new PSCClientNotificationBus();
    private XMLConfigParameterMgr parameterMgr;
    private PSCApplicationIdentifier applicationIdentifier;

    public PSCClientServiceFacade() {
        this.notificationBus.construct(this);
    }

    public void construct(RequestForwarder rf, XMLConfigParameterMgr paramMgr, File rootDirectory, PSCApplicationIdentifier p_applicationIdentifier) {
        this.requestForwarder = rf;
        this.parameterMgr = paramMgr;
        this.rootDir = rootDirectory;
        this.applicationIdentifier = p_applicationIdentifier;
        singleton = this;
    }

    public void setClientLicenseSetting(PSCClientLicenseInfo licenseSetting) {
        this.requestForwarder.setClientLicenseSetting(licenseSetting);
    }

    public PSCClientLicenseInfo getClientLicenseSetting() {
        return this.requestForwarder.getClientLicenseSetting();
    }

    public static PSCClientServiceFacade getFacade() {
        return singleton;
    }

    public XMLConfigParameterMgr getParameterManager() {
        return this.parameterMgr;
    }

    public RequestForwarder getRequestForwarder() {
        return this.requestForwarder;
    }

    public File getRootDirectory() {
        return this.rootDir;
    }

    public IniFile getIniFile() {
        if (this.iniFileAgent == null) {
            File iniFile = this.rootDir != null ? new File(this.rootDir, String.valueOf(this.applicationIdentifier.getApplicationId()) + ".ini") : new File(System.getProperty("user.home"), String.valueOf(this.applicationIdentifier.getApplicationId()) + ".ini");
            this.iniFileAgent = new IniFile(iniFile.getAbsolutePath());
        }
        return this.iniFileAgent;
    }

    public void changePassword(String serverID) {
        Notification n = new Notification("admin.change_login_password", serverID, null);
        this.notificationBus.postNotification(n);
    }

    public void showInfoMessage(String message, String serverID) {
        Notification n = new Notification(".show.infomsg", serverID, (Object)message);
        this.notificationBus.postNotification(n);
    }

    public void showErrorMessage(String message, String serverID) {
        Notification n = new Notification(".show.errormsg", serverID, (Object)message);
        this.notificationBus.postNotification(n);
    }

    public void showException(Exception e, String serverID) {
        Notification n = new Notification(".show.exception", serverID, (Object)e);
        this.notificationBus.postNotification(n);
    }

    public EOServerResponse sendRequest(String serverID, EOClientRequest request) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        return this.sendRequest(serverID, request, 0);
    }

    public EOServerResponse sendRequest(String serverID, EOClientRequest request, int timeOutInSeconds) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        return this.requestForwarder.sendRequest(serverID, request, timeOutInSeconds);
    }

    public List<ServerConnection> getServerConnections() {
        return this.requestForwarder.getServerConnections();
    }

    public ServerConnection getServerConnection(String serverID) {
        return this.requestForwarder.getServerConnection(serverID);
    }

    public List<ServerConnection> getOpenServerConnections() {
        return this.requestForwarder.getOpenServerConnections();
    }

    public String getServerName(String serverID) {
        return this.requestForwarder.getServerName(serverID);
    }

    public String getUserRealmRepositoryType(String serverID) {
        EOServerInfo serverInfo = this.requestForwarder.getServerInfo(serverID);
        assert (serverInfo != null);
        String repositoryType = null;
        if (serverInfo != null) {
            repositoryType = serverInfo.getUserRealmRepositoryType();
        }
        return repositoryType;
    }

    public EOUserAndGroupAndPermissions getUserData(String serverID) {
        return this.requestForwarder.getUserData(serverID);
    }

    public EOUserAndGroupAndPermissions getUserData(String serverID, boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        return this.requestForwarder.getUserData(serverID, forceLogin);
    }

    public EOServerInfo getServerInfo(String serverID) {
        return this.requestForwarder.getServerInfo(serverID);
    }

    public void disconnect(String serverID) {
        this.requestForwarder.disconnect(serverID);
    }

    public void disconnectAll() {
        this.requestForwarder.disconnectAll();
    }

    public void uploadFiles(String serverID, List<String> transferIDs, List<File> files) throws UnknownServerException, ServerNotAvailableException, EXServerException, LoginCanceledException, ExPrematureEndOfTransfer {
        this.requestForwarder.uploadFiles(serverID, transferIDs, files);
    }

    public void downloadFiles(String serverID, List<String> transferIDs, List<File> files) throws UnknownServerException, ExPrematureEndOfTransfer, ServerNotAvailableException, EXServerException, LoginCanceledException {
        this.requestForwarder.downloadFiles(serverID, transferIDs, files);
    }

    public void deliverAsynchronousUpdatesNow(String serverID) {
        this.requestForwarder.deliverAsynchronousUpdatesNow(serverID);
    }

    public PSCClientNotificationBus getNotificationBus() {
        return this.notificationBus;
    }

    public boolean isAdminUser(String serverID) {
        try {
            return this.isAdminUser(serverID, false);
        }
        catch (EXServerException e) {
            this.showException((Exception)((Object)e), serverID);
            return false;
        }
        catch (ServerNotAvailableException e) {
            return false;
        }
        catch (LoginCanceledException e) {
            return false;
        }
    }

    public boolean isAdminUser(String serverID, boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        EOUserAndGroupAndPermissions userData = this.getUserData(serverID, forceLogin);
        if (userData != null) {
            Collection permissionsOfCurrentUser = userData.getAllPermissions();
            return ServerOperationsPermissionChecker.isAdminUser(permissionsOfCurrentUser);
        }
        return false;
    }

    public boolean isUserAdministrator(String serverID, boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        EOUserAndGroupAndPermissions userData = this.getUserData(serverID, forceLogin);
        if (userData != null) {
            return ServerOperationsPermissionChecker.isUserAdministrator(userData.getUser());
        }
        return false;
    }

    public boolean isOperator(String serverID, boolean forceLogin) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        Collection permissionsOfCurrentUser = this.getUserData(serverID, forceLogin).getAllPermissions();
        return ServerOperationsPermissionChecker.isOperator(permissionsOfCurrentUser);
    }

    public PSCApplicationIdentifier getApplicationIdentifier() {
        return this.applicationIdentifier;
    }

    public void login(String serverName, String username, String password) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        ServerConnection sc = null;
        for (ServerConnection serverConnection : this.getServerConnections()) {
            if (!serverConnection.getServerName().equals(serverName)) continue;
            sc = serverConnection;
        }
        this.login(sc, username, password);
    }

    public void login(ServerConnection sc, String username, String password) throws ServerNotAvailableException, EXServerException, LoginCanceledException {
        if (sc != null) {
            this.requestForwarder.login(sc, username, password);
        }
    }

    public void updatePermissions(Collection<EOPermission> addedPermissions, Collection<EOPermission> removedPermissions, String serverID) throws UnknownServerException, LoginCanceledException, ServerNotAvailableException, EXServerException {
        EOGenericMessage answer;
        EOList added = new EOList("added");
        added.addAll(addedPermissions);
        EOList removed = new EOList("removed");
        removed.addAll(removedPermissions);
        EOGenericMessage parameter = new EOGenericMessage();
        parameter.addChild((EncodableObjectBase)added);
        parameter.addChild((EncodableObjectBase)removed);
        EOClientRequest removeRequest = new EOClientRequest("permission", "updatePermissions", (EncodableObjectBase)parameter);
        EOServerResponse rr = this.sendRequest(serverID, removeRequest);
        if (rr != null && (answer = (EOGenericMessage)rr.getResponseData()) != null) {
            EOUserAndGroupAndPermissions ugp = this.getUserData(serverID);
            for (Object o : answer.getChilds()) {
                if (!(o instanceof EOList)) continue;
                EOList list = (EOList)o;
                if (list.getRole().equals("added")) {
                    ugp.addPermissions(this.getPermissionsForUGP(ugp, (Collection<EOPermission>)list));
                    continue;
                }
                if (list.getRole().equals("removed")) {
                    ugp.removePermissions((Collection)list);
                    continue;
                }
                logger.error("unexpected type of answer" + list.getRole());
            }
        }
    }

    private Collection<EOPermission> getPermissionsForUGP(EOUserAndGroupAndPermissions ugp, Collection<EOPermission> allPermissions) {
        ArrayList<EOPermission> ugpPermissions = new ArrayList<EOPermission>();
        for (EOPermission permission : allPermissions) {
            if (permission.getOwnerType() == 2 || permission.getOwnerType() == 0 && permission.getOwnerID().equals(ugp.getUser().getPermissionOwnerID())) {
                ugpPermissions.add(permission);
                continue;
            }
            if (permission.getOwnerType() != 1 || !this.isOfOneGroup(permission, (Collection<EOGroup>)ugp.getGroups())) continue;
            ugpPermissions.add(permission);
        }
        return ugpPermissions;
    }

    private boolean isOfOneGroup(EOPermission permission, Collection<EOGroup> groups) {
        for (EOGroup group : groups) {
            if (!permission.getOwnerID().equals(group.getGroupName())) continue;
            return true;
        }
        return false;
    }
}

