/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.psc.eclipse.client.update;

import com.arcway.lib.eclipse.EclipseProductRetriever;
import com.arcway.lib.eclipse.extensions.ExtensionMgr;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.eclipse.gui.dialogs.HTMLTextMessageDialog;
import com.arcway.lib.eclipse.update.EclipseP2DataAreaFix;
import com.arcway.lib.eclipse.update.LaunchInfo;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.psc.eclipse.client.update.EclipseClientCompatibilityChecker;
import com.arcway.psc.eclipse.client.update.IClientUpdateProvisioningAgent;
import com.arcway.psc.eclipse.client.update.Messages;
import com.arcway.psc.eclipse.client.update.updateurl.PSCClientUpdateURLConnection;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.RequestForwarder;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUpdateFileInfo;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ClientCompatibilityOfficer {
    private static final ILogger logger = Logger.getLogger(ClientCompatibilityOfficer.class);
    private static final long MAX_ALLOWED_HTML_MESSAGE_SIZE = 0x500000L;
    private final RequestForwarder requestForwarder;
    private final ServerConnection serverConnection;
    private boolean clientIsNotCompatibleWithServer;
    private boolean clientUpdateIsRecommendedByServer;
    private final Object clientIsCurrentlyUpdatingSemaphore = new Object();
    private boolean clientIsCurrentlyUpdating = false;

    public ClientCompatibilityOfficer(RequestForwarder p_requestForwarder, ServerConnection p_serverConnection) {
        this.requestForwarder = p_requestForwarder;
        this.serverConnection = p_serverConnection;
        this.clientIsNotCompatibleWithServer = false;
        this.clientUpdateIsRecommendedByServer = false;
    }

    public void assessCompatibilityLevel() throws IOException, ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, EclipseProductRetriever.UnableToRetrieveEclipseProduct {
        EclipseClientCompatibilityChecker compatibilityChecker = EclipseClientCompatibilityChecker.getInstance();
        boolean clientSatisfiesMandatoryConstraints = false;
        File mandatoryCompatibilityConstraintsFile = null;
        boolean clientSatisfiesRecommendationConstraints = false;
        File recommendedCompatibilityConstraintsFile = null;
        try {
            mandatoryCompatibilityConstraintsFile = ClientCompatibilityOfficer.getCompatibilityConstraintsFile(this.requestForwarder, this.serverConnection.getServerID(), "mandatory/compatibilityconstraints.xml");
            clientSatisfiesMandatoryConstraints = compatibilityChecker.isClientCompatibleWithServer(mandatoryCompatibilityConstraintsFile);
            recommendedCompatibilityConstraintsFile = ClientCompatibilityOfficer.getCompatibilityConstraintsFile(this.requestForwarder, this.serverConnection.getServerID(), "recommended/compatibilityconstraints.xml");
            clientSatisfiesRecommendationConstraints = compatibilityChecker.isClientCompatibleWithServer(recommendedCompatibilityConstraintsFile);
        }
        catch (Throwable throwable) {
            this.clientIsNotCompatibleWithServer = !clientSatisfiesMandatoryConstraints;
            boolean bl = this.clientUpdateIsRecommendedByServer = !clientSatisfiesRecommendationConstraints;
            if (mandatoryCompatibilityConstraintsFile != null) {
                try {
                    FileHelper.deleteExistingFileOrDirectory((File)mandatoryCompatibilityConstraintsFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    logger.debug("Unable to delete obsolete temporary file containing mandatoryCompatibilityConstraints " + mandatoryCompatibilityConstraintsFile, (Throwable)e);
                }
            }
            if (recommendedCompatibilityConstraintsFile != null) {
                try {
                    FileHelper.deleteExistingFileOrDirectory(recommendedCompatibilityConstraintsFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    logger.debug("Unable to delete obsolete temporary file containing recommendedCompatibilityConstraintsFile " + recommendedCompatibilityConstraintsFile, (Throwable)e);
                }
            }
            throw throwable;
        }
        this.clientIsNotCompatibleWithServer = !clientSatisfiesMandatoryConstraints;
        boolean bl = this.clientUpdateIsRecommendedByServer = !clientSatisfiesRecommendationConstraints;
        if (mandatoryCompatibilityConstraintsFile != null) {
            try {
                FileHelper.deleteExistingFileOrDirectory((File)mandatoryCompatibilityConstraintsFile);
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.debug("Unable to delete obsolete temporary file containing mandatoryCompatibilityConstraints " + mandatoryCompatibilityConstraintsFile, (Throwable)e);
            }
        }
        if (recommendedCompatibilityConstraintsFile != null) {
            try {
                FileHelper.deleteExistingFileOrDirectory((File)recommendedCompatibilityConstraintsFile);
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.debug("Unable to delete obsolete temporary file containing recommendedCompatibilityConstraintsFile " + recommendedCompatibilityConstraintsFile, (Throwable)e);
            }
        }
    }

    public boolean mayClientSendThisRequest(EOClientRequest request) {
        String group = request.getReqGroup();
        String subID = request.getReqSubID();
        if (group.equals("update.client.eclipse") || group.equals("softwareconfiguration.client") || group.equals("User") && (subID.equals("Login") || subID.equals("Logout")) || group.equals("Notification") && (subID.equals("KeepAlive") || subID.equals("Subscribe") || subID.equals("Unsubscribe"))) {
            return true;
        }
        return !this.isClientCurrentlyUpdating() && !this.clientIsNotCompatibleWithServer;
    }

    public void displayAvailableAnnouncement() throws IOException, ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, EclipseProductRetriever.UnableToRetrieveEclipseProduct {
        boolean isWebstartClient = LaunchInfo.applicationWasLaunchedUsingWebStart();
        if (this.clientIsNotCompatibleWithServer) {
            String announcement = ClientCompatibilityOfficer.getCompatibilityConstraintsFileAsString(this.requestForwarder, this.serverConnection.getServerID(), "mandatory/message.html");
            if (announcement == null) {
                announcement = ClientCompatibilityOfficer.getCompatibilityConstraintsFileAsString(this.requestForwarder, this.serverConnection.getServerID(), "message.html");
            }
            if (announcement == null) {
                announcement = "<HTML><BODY>" + Messages.getString("ClientCompatibilityOfficer_Default_HTML_Announcement") + "</BODY></HTML>";
            }
            int choice = HTMLTextMessageDialog.showHTMLTextMessageDialog(null, (String)Messages.getString("ClientCompatibilityOfficer_Client_update_required"), null, (String)NLS.bind((String)Messages.getString("ClientCompatibilityOfficer_Client_update_required_DetailedMessage"), (Object[])new String[]{this.serverConnection.getServerName() != null ? this.serverConnection.getServerName() : "", this.serverConnection.getURL() != null ? this.serverConnection.getURL() : ""}), (String)announcement, (int)4, (String[])new String[]{Messages.getString("ClientCompatibilityOfficer_BTNLBL_StartUpdate"), Messages.getString("ClientCompatibilityOfficer_BTNLBL_IgnoreUpdate")}, (int)0);
            switch (choice) {
                case 0: {
                    if (isWebstartClient) {
                        this.showWebStartUpdateHints();
                        break;
                    }
                    this.startInstallingAdditionalFeaturesNow();
                }
            }
        } else if (this.clientUpdateIsRecommendedByServer) {
            String announcement = ClientCompatibilityOfficer.getCompatibilityConstraintsFileAsString(this.requestForwarder, this.serverConnection.getServerID(), "recommended/message.html");
            if (announcement == null) {
                announcement = ClientCompatibilityOfficer.getCompatibilityConstraintsFileAsString(this.requestForwarder, this.serverConnection.getServerID(), "message.html");
            }
            if (announcement == null) {
                announcement = "<HTML><BODY>" + Messages.getString("ClientCompatibilityOfficer_Default_HTML_Announcement") + "</BODY></HTML>";
            }
            int choice = HTMLTextMessageDialog.showHTMLTextMessageDialog(null, (String)Messages.getString("ClientCompatibilityOfficer_Client_update_recommended"), null, (String)NLS.bind((String)Messages.getString("ClientCompatibilityOfficer_Client_update_recommended_DetailedMessage"), (Object[])new String[]{this.serverConnection.getServerName() != null ? this.serverConnection.getServerName() : "", this.serverConnection.getURL() != null ? this.serverConnection.getURL() : ""}), (String)announcement, (int)2, (String[])new String[]{Messages.getString("ClientCompatibilityOfficer_BTNLBL_StartUpdate"), Messages.getString("ClientCompatibilityOfficer_BTNLBL_IgnoreUpdate")}, (int)0);
            switch (choice) {
                case 0: {
                    if (isWebstartClient) {
                        this.showWebStartUpdateHints();
                        break;
                    }
                    this.startInstallingAdditionalFeaturesNow();
                }
            }
        } else {
            String announcement = ClientCompatibilityOfficer.getCompatibilityConstraintsFileAsString(this.requestForwarder, this.serverConnection.getServerID(), "message.html");
            if (announcement != null) {
                HTMLTextMessageDialog.showHTMLTextMessageDialog(null, (String)Messages.getString("ClientCompatibilityOfficer_Server_maintenance_Information"), null, (String)NLS.bind((String)Messages.getString("ClientCompatibilityOfficer_Server_maintenance_Information_DetailedMessage"), (Object[])new String[]{this.serverConnection.getServerName() != null ? this.serverConnection.getServerName() : "", this.serverConnection.getURL() != null ? this.serverConnection.getURL() : ""}), (String)announcement, (int)2, (String[])new String[]{IDialogConstants.CLOSE_LABEL}, (int)0);
            }
        }
    }

    private void showWebStartUpdateHints() {
        EclipseSWTHelper.getShell();
        MessageDialog.openInformation((Shell)EclipseSWTHelper.getShell(), (String)Messages.getString("ClientCompatibilityOfficer_WebStartUpdateHints_Title"), (String)Messages.getString("ClientCompatibilityOfficer_WebStartUpdateHints_Message"));
    }

    private void startInstallingAdditionalFeaturesNow() {
        if (EclipseP2DataAreaFix.wasEclipseP2DataAreaFixAppliedDuringStartup()) {
            EclipseP2DataAreaFix.showRestartNeededBeforeChangingTheInstallation((Shell)EclipseSWTHelper.getShell());
            return;
        }
        List extensions = ExtensionMgr.getDefault().getExtension("com.arcway.lib.psc.client", "ClientUpdateProvisioningAgent", "ClientUpdateProvisioningAgent", "class", IClientUpdateProvisioningAgent.class);
        if (extensions.size() != 0) {
            this.setClientIsCurrentlyUpdating();
            Iterator iterator = extensions.iterator();
            if (iterator.hasNext()) {
                IClientUpdateProvisioningAgent agent = (IClientUpdateProvisioningAgent)iterator.next();
                try {
                    URL updateURL = PSCClientUpdateURLConnection.createPSCClientUpdateURLForPSCServer(this.serverConnection);
                    agent.installUpdatesAndNewFeatures(updateURL.toURI());
                }
                catch (MalformedURLException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                    return;
                }
                catch (URISyntaxException e) {
                    logger.error("unhandled catch block", (Throwable)e);
                    return;
                }
                assert (extensions.size() <= 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean isClientCurrentlyUpdating() {
        Object object = this.clientIsCurrentlyUpdatingSemaphore;
        synchronized (object) {
            return this.clientIsCurrentlyUpdating;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setClientIsCurrentlyUpdating() {
        Object object = this.clientIsCurrentlyUpdatingSemaphore;
        synchronized (object) {
            this.clientIsCurrentlyUpdating = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void clearClientIsCurrentlyUpdating() {
        Object object = this.clientIsCurrentlyUpdatingSemaphore;
        synchronized (object) {
            this.clientIsCurrentlyUpdating = false;
        }
    }

    private static String getCompatibilityConstraintsFileAsString(RequestForwarder p_requestForwarder, String serverID, String constraintsFilePath) throws IOException, ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, EclipseProductRetriever.UnableToRetrieveEclipseProduct {
        File f = null;
        try {
            f = ClientCompatibilityOfficer.getCompatibilityConstraintsFile(p_requestForwarder, serverID, constraintsFilePath);
            String resultString = null;
            if (f != null && f.length() < 0x500000L) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)f.length());
                de.plans.lib.util.FileHelper.copyFile((File)f, (OutputStream)byteArrayOutputStream, (boolean)true);
                resultString = byteArrayOutputStream.toString("UTF-8");
            }
            String string = resultString;
            return string;
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    private static File getCompatibilityConstraintsFile(RequestForwarder requestForwarder, String serverID, String constraintsFilePath) throws IOException, ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, EclipseProductRetriever.UnableToRetrieveEclipseProduct {
        EOUpdateFileInfo updateConstraintsFileInfo = null;
        String[] stringArray = new String[]{String.valueOf(EclipseProductRetriever.getEclipseProduct()) + "/" + constraintsFilePath, constraintsFilePath};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String constraintsFilePathCandidate = stringArray[n2];
            EOList updateSiteFilenames = new EOList();
            updateSiteFilenames.add((EncodableObjectBase)new EOString(constraintsFilePathCandidate));
            EOClientRequest req = new EOClientRequest("update.client.eclipse", "update.GetUpdateConstraintsDownloadTransferIDs", (EncodableObjectBase)updateSiteFilenames);
            EOServerResponse res = requestForwarder.sendRequest(serverID, req);
            EOList updateConstraintsFileInfoIDs = (EOList)res.getResponseData();
            updateConstraintsFileInfo = (EOUpdateFileInfo)updateConstraintsFileInfoIDs.get(0);
            if (updateConstraintsFileInfo.isAvailableOnUpdateSite()) break;
            ++n2;
        }
        assert (updateConstraintsFileInfo != null);
        File localFileCopy = null;
        if (updateConstraintsFileInfo.isAvailableOnUpdateSite()) {
            Throwable couldNotCreateLocalCopyReason = null;
            try {
                try {
                    ArrayList<String> ids = new ArrayList<String>();
                    ids.add(updateConstraintsFileInfo.getTransferID());
                    ArrayList<File> files = new ArrayList<File>();
                    localFileCopy = File.createTempFile("update", null);
                    localFileCopy.deleteOnExit();
                    files.add(localFileCopy);
                    requestForwarder.downloadFiles(serverID, ids, files);
                }
                catch (Throwable th1) {
                    Throwable e;
                    Throwable th = th1 instanceof ExPrematureEndOfTransfer && th1.getCause() != null ? th1.getCause() : th1;
                    if (th instanceof IOException) {
                        e = (IOException)th;
                        couldNotCreateLocalCopyReason = e;
                        throw e;
                    }
                    if (th instanceof ServerNotAvailableException) {
                        e = (ServerNotAvailableException)th;
                        couldNotCreateLocalCopyReason = e;
                        throw e;
                    }
                    if (th instanceof EXServerException) {
                        e = (EXServerException)th;
                        couldNotCreateLocalCopyReason = e;
                        throw e;
                    }
                    if (th instanceof LoginCanceledException) {
                        e = (LoginCanceledException)th;
                        couldNotCreateLocalCopyReason = e;
                        throw e;
                    }
                    IOException ioe = new IOException("Download of CompatibilityConstraintsFile was not successful.");
                    ioe.initCause(th1);
                    couldNotCreateLocalCopyReason = ioe;
                    if (couldNotCreateLocalCopyReason != null && localFileCopy != null) {
                        localFileCopy.delete();
                        localFileCopy = null;
                    }
                }
            }
            finally {
                if (couldNotCreateLocalCopyReason != null && localFileCopy != null) {
                    localFileCopy.delete();
                    localFileCopy = null;
                }
            }
        }
        return localFileCopy;
    }
}

