/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.pooling;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.pooling.IPoolableObjectFactory;
import java.util.Iterator;
import java.util.LinkedList;

public class Pool<E> {
    private static final ILogger logger = Logger.getLogger(Pool.class);
    private final LinkedList<E> availableElements = new LinkedList();
    private final LinkedList<E> occupiedElements = new LinkedList();
    private final IPoolableObjectFactory<E> elementFactory;

    public Pool(IPoolableObjectFactory<E> factory) {
        this.elementFactory = factory;
    }

    public synchronized E acquireObject() {
        E allocatedElement = this.availableElements.size() > 0 ? this.availableElements.removeFirst() : this.elementFactory.createPoolElement();
        this.occupiedElements.add(allocatedElement);
        return allocatedElement;
    }

    public synchronized void releaseObject(E element2release) {
        boolean found = false;
        Iterator elementIt = this.occupiedElements.iterator();
        while (elementIt.hasNext()) {
            Object element = elementIt.next();
            if (element2release != element) continue;
            elementIt.remove();
            found = true;
        }
        if (found) {
            this.availableElements.add(element2release);
        } else {
            logger.error("Attempt to release a \"alien\" object. The object to release was not allocated from this pool.");
        }
    }

    public synchronized void destroy() {
        for (Object element : this.availableElements) {
            this.elementFactory.destroyPoolElement(element);
        }
        this.availableElements.clear();
        for (Object element : this.occupiedElements) {
            this.elementFactory.destroyPoolElement(element);
        }
        this.occupiedElements.clear();
    }

    public synchronized int poolsize() {
        return this.availableElements.size() + this.occupiedElements.size();
    }
}

