/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.TabSet;

public class StyleConstantsWithoutAWT {
    public static final String ComponentElementName = "component";
    public static final String IconElementName = "icon";
    public static final Object NameAttribute = new StyleConstantsWithoutAWT("name");
    public static final Object ResolveAttribute = new StyleConstantsWithoutAWT("resolver");
    public static final Object ModelAttribute = new StyleConstantsWithoutAWT("model");
    public static final Object BidiLevel = CharacterConstants.BidiLevel;
    public static final Object FontFamily = CharacterConstants.Family;
    public static final Object FontSize = CharacterConstants.Size;
    public static final Object Bold = CharacterConstants.Bold;
    public static final Object Italic = CharacterConstants.Italic;
    public static final Object Underline = CharacterConstants.Underline;
    public static final Object StrikeThrough = CharacterConstants.StrikeThrough;
    public static final Object Superscript = CharacterConstants.Superscript;
    public static final Object Subscript = CharacterConstants.Subscript;
    public static final Object Foreground = CharacterConstants.Foreground;
    public static final Object Background = CharacterConstants.Background;
    public static final Object ComponentAttribute = CharacterConstants.ComponentAttribute;
    public static final Object IconAttribute = CharacterConstants.IconAttribute;
    public static final Object ComposedTextAttribute = new StyleConstantsWithoutAWT("composed text");
    public static final Object FirstLineIndent = ParagraphConstants.FirstLineIndent;
    public static final Object LeftIndent = ParagraphConstants.LeftIndent;
    public static final Object RightIndent = ParagraphConstants.RightIndent;
    public static final Object LineSpacing = ParagraphConstants.LineSpacing;
    public static final Object SpaceAbove = ParagraphConstants.SpaceAbove;
    public static final Object SpaceBelow = ParagraphConstants.SpaceBelow;
    public static final Object Alignment = ParagraphConstants.Alignment;
    public static final Object TabSet = ParagraphConstants.TabSet;
    public static final Object Orientation = ParagraphConstants.Orientation;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_JUSTIFIED = 3;
    static Object[] keys = new Object[]{NameAttribute, ResolveAttribute, BidiLevel, FontFamily, FontSize, Bold, Italic, Underline, StrikeThrough, Superscript, Subscript, Foreground, Background, ComponentAttribute, IconAttribute, FirstLineIndent, LeftIndent, RightIndent, LineSpacing, SpaceAbove, SpaceBelow, Alignment, TabSet, Orientation, ModelAttribute, ComposedTextAttribute};
    private final String representation;

    public String toString() {
        return this.representation;
    }

    public static int getBidiLevel(AttributeSet a) {
        Integer o = (Integer)a.getAttribute(BidiLevel);
        if (o != null) {
            return o;
        }
        return 0;
    }

    public static void setBidiLevel(MutableAttributeSet a, int o) {
        a.addAttribute(BidiLevel, new Integer(o));
    }

    public static String getFontFamily(AttributeSet a) {
        String family = (String)a.getAttribute(FontFamily);
        if (family == null) {
            family = "Monospaced";
        }
        return family;
    }

    public static void setFontFamily(MutableAttributeSet a, String fam) {
        a.addAttribute(FontFamily, fam);
    }

    public static int getFontSize(AttributeSet a) {
        Integer size = (Integer)a.getAttribute(FontSize);
        if (size != null) {
            return size;
        }
        return 12;
    }

    public static void setFontSize(MutableAttributeSet a, int s) {
        a.addAttribute(FontSize, new Integer(s));
    }

    public static boolean isBold(AttributeSet a) {
        Boolean bold = (Boolean)a.getAttribute(Bold);
        if (bold != null) {
            return bold;
        }
        return false;
    }

    public static void setBold(MutableAttributeSet a, boolean b) {
        a.addAttribute(Bold, b);
    }

    public static boolean isItalic(AttributeSet a) {
        Boolean italic = (Boolean)a.getAttribute(Italic);
        if (italic != null) {
            return italic;
        }
        return false;
    }

    public static void setItalic(MutableAttributeSet a, boolean b) {
        a.addAttribute(Italic, b);
    }

    public static boolean isUnderline(AttributeSet a) {
        Boolean underline = (Boolean)a.getAttribute(Underline);
        if (underline != null) {
            return underline;
        }
        return false;
    }

    public static boolean isStrikeThrough(AttributeSet a) {
        Boolean strike = (Boolean)a.getAttribute(StrikeThrough);
        if (strike != null) {
            return strike;
        }
        return false;
    }

    public static boolean isSuperscript(AttributeSet a) {
        Boolean superscript = (Boolean)a.getAttribute(Superscript);
        if (superscript != null) {
            return superscript;
        }
        return false;
    }

    public static boolean isSubscript(AttributeSet a) {
        Boolean subscript = (Boolean)a.getAttribute(Subscript);
        if (subscript != null) {
            return subscript;
        }
        return false;
    }

    public static void setUnderline(MutableAttributeSet a, boolean b) {
        a.addAttribute(Underline, b);
    }

    public static void setStrikeThrough(MutableAttributeSet a, boolean b) {
        a.addAttribute(StrikeThrough, b);
    }

    public static void setSuperscript(MutableAttributeSet a, boolean b) {
        a.addAttribute(Superscript, b);
    }

    public static void setSubscript(MutableAttributeSet a, boolean b) {
        a.addAttribute(Subscript, b);
    }

    public static float getFirstLineIndent(AttributeSet a) {
        Float indent = (Float)a.getAttribute(FirstLineIndent);
        if (indent != null) {
            return indent.floatValue();
        }
        return 0.0f;
    }

    public static void setFirstLineIndent(MutableAttributeSet a, float i) {
        a.addAttribute(FirstLineIndent, new Float(i));
    }

    public static float getRightIndent(AttributeSet a) {
        Float indent = (Float)a.getAttribute(RightIndent);
        if (indent != null) {
            return indent.floatValue();
        }
        return 0.0f;
    }

    public static void setRightIndent(MutableAttributeSet a, float i) {
        a.addAttribute(RightIndent, new Float(i));
    }

    public static float getLeftIndent(AttributeSet a) {
        Float indent = (Float)a.getAttribute(LeftIndent);
        if (indent != null) {
            return indent.floatValue();
        }
        return 0.0f;
    }

    public static void setLeftIndent(MutableAttributeSet a, float i) {
        a.addAttribute(LeftIndent, new Float(i));
    }

    public static float getLineSpacing(AttributeSet a) {
        Float space = (Float)a.getAttribute(LineSpacing);
        if (space != null) {
            return space.floatValue();
        }
        return 0.0f;
    }

    public static void setLineSpacing(MutableAttributeSet a, float i) {
        a.addAttribute(LineSpacing, new Float(i));
    }

    public static float getSpaceAbove(AttributeSet a) {
        Float space = (Float)a.getAttribute(SpaceAbove);
        if (space != null) {
            return space.floatValue();
        }
        return 0.0f;
    }

    public static void setSpaceAbove(MutableAttributeSet a, float i) {
        a.addAttribute(SpaceAbove, new Float(i));
    }

    public static float getSpaceBelow(AttributeSet a) {
        Float space = (Float)a.getAttribute(SpaceBelow);
        if (space != null) {
            return space.floatValue();
        }
        return 0.0f;
    }

    public static void setSpaceBelow(MutableAttributeSet a, float i) {
        a.addAttribute(SpaceBelow, new Float(i));
    }

    public static int getAlignment(AttributeSet a) {
        Integer align = (Integer)a.getAttribute(Alignment);
        if (align != null) {
            return align;
        }
        return 0;
    }

    public static void setAlignment(MutableAttributeSet a, int align) {
        a.addAttribute(Alignment, new Integer(align));
    }

    public static TabSet getTabSet(AttributeSet a) {
        TabSet tabs = (TabSet)a.getAttribute(TabSet);
        return tabs;
    }

    public static void setTabSet(MutableAttributeSet a, TabSet tabs) {
        a.addAttribute(TabSet, tabs);
    }

    StyleConstantsWithoutAWT(String representation) {
        this.representation = representation;
    }

    public static class CharacterConstants
    extends StyleConstantsWithoutAWT
    implements AttributeSet.CharacterAttribute {
        public static final Object Underline = new CharacterConstants("underline");
        public static final Object StrikeThrough = new CharacterConstants("strikethrough");
        public static final Object Superscript = new CharacterConstants("superscript");
        public static final Object Subscript = new CharacterConstants("subscript");
        public static final Object ComponentAttribute = new CharacterConstants("component");
        public static final Object IconAttribute = new CharacterConstants("icon");
        public static final Object BidiLevel = new CharacterConstants("bidiLevel");
        public static final Object Family = FontConstants.Family;
        public static final Object Size = FontConstants.Size;
        public static final Object Bold = FontConstants.Bold;
        public static final Object Italic = FontConstants.Italic;
        public static final Object Foreground = ColorConstants.Foreground;
        public static final Object Background = ColorConstants.Background;

        private CharacterConstants(String representation) {
            super(representation);
        }
    }

    public static class ColorConstants
    extends StyleConstantsWithoutAWT
    implements AttributeSet.ColorAttribute,
    AttributeSet.CharacterAttribute {
        public static final Object Foreground = new ColorConstants("foreground");
        public static final Object Background = new ColorConstants("background");

        private ColorConstants(String representation) {
            super(representation);
        }
    }

    public static class FontConstants
    extends StyleConstantsWithoutAWT
    implements AttributeSet.FontAttribute,
    AttributeSet.CharacterAttribute {
        public static final Object Family = new FontConstants("family");
        public static final Object Size = new FontConstants("size");
        public static final Object Bold = new FontConstants("bold");
        public static final Object Italic = new FontConstants("italic");

        private FontConstants(String representation) {
            super(representation);
        }
    }

    public static class ParagraphConstants
    extends StyleConstantsWithoutAWT
    implements AttributeSet.ParagraphAttribute {
        public static final Object FirstLineIndent = new ParagraphConstants("FirstLineIndent");
        public static final Object LeftIndent = new ParagraphConstants("LeftIndent");
        public static final Object RightIndent = new ParagraphConstants("RightIndent");
        public static final Object LineSpacing = new ParagraphConstants("LineSpacing");
        public static final Object SpaceAbove = new ParagraphConstants("SpaceAbove");
        public static final Object SpaceBelow = new ParagraphConstants("SpaceBelow");
        public static final Object Alignment = new ParagraphConstants("Alignment");
        public static final Object TabSet = new ParagraphConstants("TabSet");
        public static final Object Orientation = new ParagraphConstants("Orientation");

        private ParagraphConstants(String representation) {
            super(representation);
        }
    }
}

