/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util.valueranges;

import de.plans.lib.util.valueranges.IString;
import de.plans.lib.util.valueranges.ValueRangeHelperListElement;
import java.util.List;

public class ValueRangeHelperStringWithProposals
extends ValueRangeHelperListElement {
    private final String[] proposals;
    private final IString persistentLocation;

    public ValueRangeHelperStringWithProposals(List proposals, IString associatedPersistentLocation, boolean shallUseEmptyStringSymbol) {
        this.proposals = new String[proposals.size()];
        int c = 0;
        while (c < proposals.size()) {
            this.proposals[c] = (String)proposals.get(c);
            ++c;
        }
        this.persistentLocation = associatedPersistentLocation;
        this.isUsingEmptyStringSymbol = shallUseEmptyStringSymbol;
    }

    @Override
    public boolean check(String valueToCheck) {
        assert (valueToCheck != null) : "value must not be null";
        this.lastCheckWasSuccessful = true;
        return this.lastCheckWasSuccessful;
    }

    @Override
    public boolean acceptsNewValues() {
        return true;
    }

    @Override
    protected String[] getList() {
        String currentValue = this.persistentLocation.getValue();
        boolean isInList = false;
        if (!currentValue.equals("")) {
            String[] stringArray = this.proposals;
            int n = this.proposals.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.equals(currentValue)) {
                    isInList = true;
                    break;
                }
                ++n2;
            }
        }
        if (!isInList && !currentValue.equals("")) {
            String[] newList = new String[this.proposals.length + 1];
            newList[0] = currentValue;
            System.arraycopy(this.proposals, 0, newList, 1, this.proposals.length);
            return newList;
        }
        return this.proposals;
    }

    @Override
    protected String getThisElement() {
        return this.persistentLocation.getValue();
    }

    @Override
    protected void setThisElement(String displayRepresentation) {
        this.persistentLocation.setValue(displayRepresentation.trim());
    }

    @Override
    protected void createNewListElement(String displayRepresentation) {
        this.setThisElement(displayRepresentation);
    }

    @Override
    public boolean acceptsEmptyString() {
        return true;
    }

    protected boolean isUsingEmptyStringSymbol() {
        return false;
    }
}

