/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.ui.editor.widgetAdapter;

import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IIteratorRW_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.EnumerationItem_WithLabelIconDecorationsAndSelectability;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractRelationWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MultipleChoiceWidgetRelationWidgetAdapter
extends AbstractRelationWidgetAdapter {
    private static final ILogger logger = Logger.getLogger(MultipleChoiceWidgetRelationWidgetAdapter.class);
    private ISetRW_<Object> latestSelectedKeys;

    public MultipleChoiceWidgetRelationWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds, Object objectID, Object roleID) {
        super(widgetAdapterManager, playgrounds, objectID, roleID);
    }

    @Override
    public List<Object> getValueRange() {
        ArrayList<Object> enumerationItems = new ArrayList<Object>();
        this.addEnumerationItemsForRelations(this.getPlayground().getRelationsThatMustNotBeDeleted(this.getObjectID(), this.getRoleID()), EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.MANDATORILY_CHECKED, enumerationItems);
        this.addEnumerationItemsForRelations(this.getPlayground().getRelationsThatMustBeCreated(this.getObjectID(), this.getRoleID()), EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.MANDATORILY_CHECKED, enumerationItems);
        this.addEnumerationItemsForRelations(this.getPlayground().getRelationsThatMayBeDeleted(this.getObjectID(), this.getRoleID(), false), EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.SELECTABLE_INITIALLYCHECKED, enumerationItems);
        this.addEnumerationItemsForRelations(this.getPlayground().getRelationsThatMayBeCreated(this.getObjectID(), this.getRoleID(), false), this.getPlayground().getRelationsThatAreRecommendedToBeCreated(this.getObjectID(), this.getRoleID(), false), enumerationItems);
        this.addEnumerationItemsForRelations(this.getPlayground().getRelationsThatMustBeDeleted(this.getObjectID(), this.getRoleID()), EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.MANDATORILY_UNCHECKED, enumerationItems);
        this.addEnumerationItemsForRelations(this.getPlayground().getRelationsThatMustNotBeCreated(this.getObjectID(), this.getRoleID()), EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.MANDATORILY_UNCHECKED, enumerationItems);
        return enumerationItems;
    }

    private void addEnumerationItemsForRelations(ISet_<? extends Object> relations, EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability selectability, List<EnumerationItem_WithLabelIconDecorationsAndSelectability> enumerationItems) {
        for (Object key : relations) {
            enumerationItems.add(new EnumerationItem_WithLabelIconDecorationsAndSelectability(key, this.getPlayground().getLabel(this.getObjectID(), this.getRoleID(), key), this.getPlayground().getLabelDecoration(this.getObjectID(), this.getRoleID(), key), this.getPlayground().getIcon16x16(this.getObjectID(), this.getRoleID(), key), this.getPlayground().getIconDecoration7x8(this.getObjectID(), this.getRoleID(), key), selectability));
        }
        MultipleChoiceWidgetRelationWidgetAdapter.sortAddedEnumerationItems(enumerationItems, relations.size());
    }

    private void addEnumerationItemsForRelations(ISet_<? extends Object> relationsThatMayBeCreated, ISet_<? extends Object> relationsThatAreRecommendedToBeCreated, List<EnumerationItem_WithLabelIconDecorationsAndSelectability> enumerationItems) {
        for (Object key : relationsThatMayBeCreated) {
            EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability selectability = null;
            selectability = relationsThatAreRecommendedToBeCreated.contains(key) ? EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.SELECTABLE_INITIALLYUNCHECKED_RECOMMENDED : EnumerationItem_WithLabelIconDecorationsAndSelectability.Selectability.SELECTABLE_INITIALLYUNCHECKED_DEFAULT;
            enumerationItems.add(new EnumerationItem_WithLabelIconDecorationsAndSelectability(key, this.getPlayground().getLabel(this.getObjectID(), this.getRoleID(), key), this.getPlayground().getLabelDecoration(this.getObjectID(), this.getRoleID(), key), this.getPlayground().getIcon16x16(this.getObjectID(), this.getRoleID(), key), this.getPlayground().getIconDecoration7x8(this.getObjectID(), this.getRoleID(), key), selectability));
        }
        MultipleChoiceWidgetRelationWidgetAdapter.sortAddedEnumerationItems(enumerationItems, relationsThatMayBeCreated.size());
    }

    private static void sortAddedEnumerationItems(List<EnumerationItem_WithLabelIconDecorationsAndSelectability> enumerationItems, int numberOfAddedItems) {
        Collections.sort(enumerationItems.subList(enumerationItems.size() - numberOfAddedItems, enumerationItems.size()), new Comparator<EnumerationItem_WithLabelIconDecorationsAndSelectability>(){

            @Override
            public int compare(EnumerationItem_WithLabelIconDecorationsAndSelectability o1, EnumerationItem_WithLabelIconDecorationsAndSelectability o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
    }

    @Override
    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        ISet_<Object> values = this.getPlayground().getCreatedAndNotDeletedRelations(this.getObjectID(), this.getRoleID(), false);
        this.latestSelectedKeys = new HashSet_(values, this.getPlayground().getRelationReferenceHasher());
        return values;
    }

    @Override
    public void widgetModified() {
        IDataWidget widget = this.getWidget();
        ISet_ currentValue = null;
        try {
            this.removeWidgetAdapterError();
            currentValue = (ISet_)widget.getCurrentValue();
        }
        catch (Exception e) {
            this.setWidgetAdapterError(null);
            logger.error("Wrong value in multiple choice widget for relations.", (Throwable)e);
            return;
        }
        if (this.latestSelectedKeys != null) {
            IIteratorRW_ keyIterator = this.latestSelectedKeys.iterator();
            while (keyIterator.hasNext()) {
                Object key = keyIterator.next();
                if (currentValue.contains(key)) continue;
                this.getPlayground().removeRelation(this.getObjectID(), this.getRoleID(), key);
                keyIterator.remove();
            }
        }
        for (Object key : currentValue) {
            if (this.latestSelectedKeys.contains(key)) continue;
            this.getPlayground().addRelation(this.getObjectID(), this.getRoleID(), key);
            this.latestSelectedKeys.add(key);
        }
        this.getPlayground().updateAdapters(this);
    }
}

