/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.saveimage;

import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.saveimage.ByteBuffer;
import com.arcway.lib.graphics.saveimage.ByteBufferImageOutputStream;
import com.arcway.lib.graphics.saveimage.FileImageOutputStream;
import com.arcway.lib.graphics.saveimage.ImageOutputStream;
import com.arcway.lib.graphics.saveimage.ImageWriter;
import com.arcway.lib.graphics.saveimage.PNGImageWriter;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.IOException;

public final class ImageIO {
    private ImageIO() {
    }

    private static ImageOutputStream createImageOutputStream(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("output == null!");
        }
        return new ByteBufferImageOutputStream(byteBuffer);
    }

    private static ImageOutputStream createImageOutputStream(File output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("output == null!");
        }
        return new FileImageOutputStream(output);
    }

    private static boolean write(IImageData im, ImageOutputStream output, int pixelPerMeterX, int pixelPerMeterY) throws IOException {
        if (im == null) {
            throw new IllegalArgumentException("im == null!");
        }
        if (output == null) {
            throw new IllegalArgumentException("output == null!");
        }
        PNGImageWriter writer = new PNGImageWriter();
        ((ImageWriter)writer).setOutput(output);
        ((ImageWriter)writer).write(im, pixelPerMeterX, pixelPerMeterY);
        output.flush();
        writer.dispose();
        return true;
    }

    public static boolean write(IImageData im, File output, int pixelPerMeterX, int pixelPerMeterY) throws JvmExternalResourceInteractionException {
        boolean val;
        if (output == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageOutputStream stream = null;
        FileHelper.deleteFileOrDirectory((File)output);
        try {
            stream = ImageIO.createImageOutputStream(output);
        }
        catch (IOException e) {
            throw new JvmExternalResourceInteractionException((Throwable)e);
        }
        try {
            val = ImageIO.write(im, stream, pixelPerMeterX, pixelPerMeterY);
        }
        catch (IOException e) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new JvmExternalResourceInteractionException((Throwable)e);
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new JvmExternalResourceInteractionException((Throwable)e);
        }
        return val;
    }

    public static boolean write(IImageData im, ByteBuffer byteBuffer, int pixelPerMeterX, int pixelPerMeterY) throws EXImageTooBig {
        boolean val;
        if (byteBuffer == null) {
            throw new IllegalArgumentException("output == null!");
        }
        ImageOutputStream stream = null;
        byteBuffer.clear();
        stream = ImageIO.createImageOutputStream(byteBuffer);
        try {
            val = ImageIO.write(im, stream, pixelPerMeterX, pixelPerMeterY);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot happen while writing into byte array.", e);
        }
        catch (OutOfMemoryError e) {
            byteBuffer.clear();
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byteBuffer.clear();
            throw new EXImageTooBig();
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot happen while writing into byte array.", e);
        }
        return val;
    }
}

