/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linestyles;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.graphics.linestyles.LinePieceProcessorFigure;
import com.arcway.lib.graphics.linestyles.LineStyleDrawProcessor;

public class LinePieceProcessorFigureArc
extends LinePieceProcessorFigure {
    double angleComingFrom;
    double angleGoingTo;
    double x;
    double y;
    double rx;
    double ry;
    double a1;
    double a2;
    double da1;
    double da2;

    public LinePieceProcessorFigureArc(LineStyleDrawProcessor lineDrawProcessor, double x, double y, double rx, double ry, double angleComingFrom, double angleStart, double angleEnd, double angleGoingTo) {
        this.lineDrawProcessor = lineDrawProcessor;
        this.angleComingFrom = angleComingFrom;
        this.angleGoingTo = angleGoingTo;
        this.x = x;
        this.y = y;
        this.rx = rx;
        this.ry = ry;
        this.a1 = angleStart;
        this.a2 = angleEnd;
        this.da1 = angleStart;
        this.da2 = angleEnd;
    }

    @Override
    public double getArcLength() {
        return Geo.arcLengthArc(this.rx, this.ry, this.da1, this.da2);
    }

    protected double getOriginalArcLength() {
        return Geo.arcLengthArc(this.rx, this.ry, this.a1, this.a2);
    }

    @Override
    public void setArcLength(double arcLength) {
        double sign = (this.a2 - this.a1) / Math.abs(this.a2 - this.a1);
        this.da2 = Geo.angleArc(this.rx, this.ry, this.da1, sign * arcLength) + this.da1;
    }

    @Override
    public void skipArcLength(double arcLength) {
        double sign = (this.a2 - this.a1) / Math.abs(this.a2 - this.a1);
        this.da1 = Geo.angleArc(this.rx, this.ry, this.da1, sign * arcLength) + this.da1;
    }

    @Override
    public void drawBeginningPart() {
        this.lineDrawProcessor.drawArcBeginningPart(this.x, this.y, this.rx, this.ry, this.angleComingFrom, this.da1, this.da2, this.getArcLength(), this.angleGoingTo);
    }

    @Override
    public void drawCenterPart() {
        this.lineDrawProcessor.drawArcCenterPart(this.x, this.y, this.rx, this.ry, this.angleComingFrom, this.da1, this.da2, this.getArcLength(), this.angleGoingTo);
    }

    @Override
    public void drawEndPart() {
        this.lineDrawProcessor.drawArcEndPart(this.x, this.y, this.rx, this.ry, this.angleComingFrom, this.da1, this.da2, this.getArcLength(), this.angleGoingTo);
    }

    @Override
    public void next() {
        this.da1 = this.da2;
        this.da2 = this.a2;
    }
}

