/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.devicedrivers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;

public class AnalyzeEMFFile {
    private static final Map<Integer, String> EMR_RECORD_TYPE = new TreeMap<Integer, String>();
    private static final Map<Integer, String> EMR_COMMENT_TYPES;
    private static final Map<Integer, String> EMFPLUS_RECORD_TYPES;
    private static final char[] HEX_ARRAY;

    static {
        AnalyzeEMFFile.add(EMR_RECORD_TYPE, "EMR_HEADER", 1);
        AnalyzeEMFFile.add(EMR_RECORD_TYPE, "EMR_COMMENT", 70);
        AnalyzeEMFFile.add(EMR_RECORD_TYPE, "EMR_EOF", 14);
        EMR_COMMENT_TYPES = new TreeMap<Integer, String>();
        AnalyzeEMFFile.add(EMR_COMMENT_TYPES, "EMR_COMMENT_EMFPLUS", 726027589);
        EMFPLUS_RECORD_TYPES = new TreeMap<Integer, String>();
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_HEADER", 16385);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_END_OF_FILE", 16386);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_CLEAR", 16388);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_SET_RENDERING_ORIGIN", 16413);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_SET_ANTI_ALIAS_MODE", 16414);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_SET_TEXT_RENDERING_HINT", 16415);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_SET_INTERPOLATION_MODE", 16417);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_SET_PIXEL_OFFSET_MODE", 16418);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_SET_COMPOSITION_MODE", 16419);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_SET_COMPOSITING_QUALITY", 16420);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_SAVE", 16421);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_RESTORE", 16422);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_FILLPOLYGON", 16396);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_DRAW_LINES", 16397);
        AnalyzeEMFFile.add(EMFPLUS_RECORD_TYPES, "EMFPLUS_OBJECT", 16392);
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    }

    private static void add(Map<Integer, String> map, String name, int value) {
        map.put(value, name);
    }

    public static void main(String[] args) throws IOException {
        AnalyzeEMFFile.testEMF("D:\\test\\test.emf");
        AnalyzeEMFFile.testEMF("D:\\emftest\\files_and_images\\88a1e990000336d30177eb8b9f770a52.emf");
    }

    private static void testEMF(String filename) throws FileNotFoundException, IOException {
        File file = new File(filename);
        AnalyzeEMFFile.title(file.getName());
        FileInputStream is = new FileInputStream(file);
        AnalyzeEMFFile.dumpEMFFile(is);
        System.out.println();
    }

    private static void dumpEMFFile(FileInputStream is) throws IOException {
        int size;
        AnalyzeEMFFile.read4BytesEnum("Type", EMR_RECORD_TYPE, is);
        int rest = size = AnalyzeEMFFile.read4ByteValue("Size", is);
        AnalyzeEMFFile.readRectL("Bounds in logical Units", is);
        AnalyzeEMFFile.readRectL("Frame in 0.01 mm", is);
        AnalyzeEMFFile.read4ByteMagicAsASCII("RecordSignature", is);
        AnalyzeEMFFile.read4ByteHex("Version", is);
        int bytes = AnalyzeEMFFile.read4ByteValue("Bytes", is);
        AnalyzeEMFFile.read4ByteValue("Records", is);
        AnalyzeEMFFile.readWordValue("Handles", is);
        AnalyzeEMFFile.read2ByteHex("Reserved", is);
        int bytesDescription = 2 * AnalyzeEMFFile.read4ByteValue("nDescription", is);
        AnalyzeEMFFile.read4ByteValue("offDescription", is);
        AnalyzeEMFFile.read4ByteValue("nPalEntries", is);
        AnalyzeEMFFile.readSizeL("Device size in pixels", is);
        AnalyzeEMFFile.readSizeL("Device size in millimeters ", is);
        int bytesPixelFormat = 0;
        rest -= 88;
        if (size - bytesDescription > 88) {
            bytesPixelFormat = AnalyzeEMFFile.read4ByteValue("cbPixelFormat", is);
            AnalyzeEMFFile.read4ByteValue("offPixelFormat", is);
            AnalyzeEMFFile.read4ByteHex("bOpenGL", is);
            rest -= 12;
        }
        if (size - bytesDescription - bytesPixelFormat > 100) {
            AnalyzeEMFFile.read4ByteValue("Device size in MicrometersX", is);
            AnalyzeEMFFile.read4ByteValue("Device size in MicrometersY", is);
            rest -= 8;
        }
        if (rest > 0) {
            AnalyzeEMFFile.readWordArray("Remaining Header Data ", rest / 2, is);
        }
        while (AnalyzeEMFFile.readEMRRecord(is)) {
        }
        is.close();
    }

    private static void readEmbeddedEMFData(InputStream is) throws IOException {
        int c = is.read();
        if (c != -1) {
            System.out.println();
            AnalyzeEMFFile.title("Embedded EMF File");
            int count = 0;
            while (c != -1) {
                if (c >= 0 && c < 32) {
                    System.out.print(".");
                } else {
                    char cr = (char)c;
                    System.out.print(cr);
                }
                c = is.read();
                if (++count % 64 != 0) continue;
                System.out.println();
            }
            System.out.println();
        }
        is.close();
    }

    private static void title(String title) {
        System.out.println();
        System.out.println(title);
        int i = 0;
        while (i < title.length()) {
            System.out.print("=");
            ++i;
        }
        System.out.println();
    }

    private static boolean readEMRRecord(InputStream is) throws IOException {
        int typeNumber = AnalyzeEMFFile.readLongValue(is);
        boolean cont = typeNumber != 14;
        int recordSize = AnalyzeEMFFile.readLongValue(is);
        String type = AnalyzeEMFFile.resolve(EMR_RECORD_TYPE, typeNumber);
        System.out.print(String.valueOf(type) + " (Size " + recordSize + ")");
        int rest = recordSize - 8;
        if (rest > 0) {
            InputStream recordData = AnalyzeEMFFile.readSubData(is, rest);
            if ("EMR_COMMENT".equals(type)) {
                System.out.println();
                AnalyzeEMFFile.readEmrComment(recordData);
            } else {
                System.out.println();
                AnalyzeEMFFile.readHexData(rest, recordData);
                System.out.println();
            }
        } else {
            System.out.println();
        }
        return cont;
    }

    private static void readEmrComment(InputStream is) throws IOException {
        int dataSize = AnalyzeEMFFile.readLongValue(is);
        int commentIdentifier = AnalyzeEMFFile.readLongValue(is);
        String type = AnalyzeEMFFile.resolve(EMR_COMMENT_TYPES, commentIdentifier);
        System.out.print(String.valueOf(type) + " (Size " + dataSize + ")");
        int rest = dataSize - 4;
        if (rest > 0) {
            InputStream recordData = AnalyzeEMFFile.readSubData(is, rest);
            if ("EMR_COMMENT_EMFPLUS".equals(type)) {
                System.out.println();
                AnalyzeEMFFile.readEmrCommentEMFPlus(recordData);
            } else {
                System.out.println();
                AnalyzeEMFFile.readHexData(rest, recordData);
                System.out.println();
            }
        }
    }

    private static void readEmrCommentEMFPlus(InputStream is) throws IOException {
        while (AnalyzeEMFFile.readEMFPlusRecord(is)) {
        }
    }

    private static boolean readEMFPlusRecord(InputStream is) throws IOException {
        int typeNumber = AnalyzeEMFFile.readWordValue(is);
        boolean cont = typeNumber != 16386;
        int flags = AnalyzeEMFFile.readWordValue(is);
        int size = AnalyzeEMFFile.readLongValue(is);
        int dataSize = AnalyzeEMFFile.readLongValue(is);
        String type = AnalyzeEMFFile.resolve(EMFPLUS_RECORD_TYPES, typeNumber);
        System.out.print(String.valueOf(type) + " (Flags 0x" + Integer.toHexString(flags) + ", Size " + Integer.toHexString(size) + ", DataSize " + Integer.toHexString(dataSize) + ")");
        System.out.println();
        int restData = dataSize;
        int restRecord = size - 12;
        InputStream recordData = AnalyzeEMFFile.readSubData(is, restData);
        int restPadding = restRecord - restData;
        InputStream paddingData = AnalyzeEMFFile.readSubData(is, restPadding);
        System.out.println();
        AnalyzeEMFFile.readHexData(restData, recordData);
        AnalyzeEMFFile.readHexData(restPadding, paddingData);
        System.out.println();
        return cont;
    }

    private static void writePoints(int count, InputStream is) throws IOException {
        int i = 0;
        while (i < count) {
            AnalyzeEMFFile.writePoint(AnalyzeEMFFile.readWordValue(is), AnalyzeEMFFile.readWordValue(is));
            ++i;
        }
    }

    private static void writeRectangleBRTL(InputStream recordData) throws IOException {
        int bottom = AnalyzeEMFFile.readWordValue(recordData);
        int right = AnalyzeEMFFile.readWordValue(recordData);
        int top = AnalyzeEMFFile.readWordValue(recordData);
        int left = AnalyzeEMFFile.readWordValue(recordData);
        AnalyzeEMFFile.writeRectangleLTRB(new int[]{left, top, right, bottom});
    }

    private static void readHexData(int byteCount, InputStream is) throws IOException {
        int off = 0;
        int rest = byteCount;
        while (rest > 0) {
            int now = Math.min(4, rest);
            byte[] data = new byte[now];
            is.read(data);
            System.out.println("\t" + off + ": 0x" + AnalyzeEMFFile.bytesToHex(data));
            off += now;
            rest -= now;
        }
    }

    private static void dump(String title, byte[] bytes) {
        System.out.println(String.valueOf(title) + ": " + AnalyzeEMFFile.bytesToHex(bytes));
    }

    private static InputStream readSubData(InputStream is, int byteCount) throws IOException {
        byte[] data = new byte[byteCount];
        is.read(data);
        return new ByteArrayInputStream(data);
    }

    private static InputStream wordIS(int[] ints) {
        byte[] data = new byte[ints.length * 2];
        int off = 0;
        int i = 0;
        while (i < ints.length) {
            data[off] = (byte)(i % 255);
            data[off + 1] = (byte)(i >> 8);
            off += 2;
            ++i;
        }
        return new ByteArrayInputStream(data);
    }

    private static int read4ByteMagicAsASCII(String title, InputStream is) throws IOException {
        byte[] bytes = new byte[4];
        is.read(bytes);
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] >= 0 && bytes[i] < 32) {
                bytes[i] = 46;
            }
            ++i;
        }
        String s = new String(bytes, "ISO-8859-1");
        System.out.println(String.valueOf(title) + ": " + s);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        return AnalyzeEMFFile.readByteValue(bis);
    }

    private static void readEnum(String title, Map<Integer, String> map, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        int value = AnalyzeEMFFile.readCardValue(is);
        String name = AnalyzeEMFFile.resolve(map, value);
        System.out.println(name);
    }

    private static void read4BytesEnum(String title, Map<Integer, String> map, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        int value = AnalyzeEMFFile.readLongValue(is);
        String name = AnalyzeEMFFile.resolve(map, value);
        System.out.println(name);
    }

    private static String resolve(Map<Integer, String> map, int value) {
        String name = map.get(value);
        if (name == null) {
            name = "0x" + Integer.toHexString(value);
        }
        return name;
    }

    private static int read2ByteHex(String title, InputStream is) throws IOException {
        byte[] bytes = new byte[2];
        bytes[1] = (byte)is.read();
        bytes[0] = (byte)is.read();
        System.out.println(String.valueOf(title) + ": 0x" + AnalyzeEMFFile.bytesToHex(bytes));
        return bytes[0] + 256 * bytes[1];
    }

    private static void read4ByteHex(String title, InputStream is) throws IOException {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)is.read();
        bytes[2] = (byte)is.read();
        bytes[1] = (byte)is.read();
        bytes[0] = (byte)is.read();
        System.out.println(String.valueOf(title) + ": 0x" + AnalyzeEMFFile.bytesToHex(bytes));
    }

    private static void readWordArray(String title, int count, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        AnalyzeEMFFile.readWordArray(count, is);
        System.out.println();
    }

    private static void readCardArray(String title, int count, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        AnalyzeEMFFile.readCardArray(count, is);
        System.out.println();
    }

    private static void readCardArray(int count, InputStream is) throws IOException {
        int i = 0;
        while (i < count) {
            if (i > 0) {
                System.out.print(",");
            }
            int value = AnalyzeEMFFile.readCardValue(is);
            System.out.print(value);
            ++i;
        }
    }

    private static void readLongArray(int count, InputStream is) throws IOException {
        int i = 0;
        while (i < count) {
            if (i > 0) {
                System.out.println();
            }
            int value = AnalyzeEMFFile.readLongValue(is);
            System.out.println("\t" + value);
            ++i;
        }
    }

    private static void readWordArray(int count, InputStream is) throws IOException {
        int i = 0;
        while (i < count) {
            if (i > 0) {
                System.out.print(",");
            }
            int value = AnalyzeEMFFile.readWordValue(is);
            System.out.print(value);
            ++i;
        }
    }

    private static int[] readRectangle(String title, InputStream is) throws IOException {
        System.out.println(String.valueOf(title) + ":");
        int[] rect = AnalyzeEMFFile.readRectangle(is);
        AnalyzeEMFFile.writeRectangleLTRB(rect);
        return rect;
    }

    private static int[] readRectL(String title, InputStream is) throws IOException {
        System.out.println(String.valueOf(title) + ":");
        int[] rect = AnalyzeEMFFile.readRectL(is);
        AnalyzeEMFFile.writeRectangleLTRB(rect);
        return rect;
    }

    private static int[] readSizeL(String title, InputStream is) throws IOException {
        System.out.println(String.valueOf(title) + ":");
        int[] rect = AnalyzeEMFFile.readSizeL(is);
        AnalyzeEMFFile.writeSize(rect);
        return rect;
    }

    private static void writeRectangleLTRB(int[] rect) {
        AnalyzeEMFFile.writeRect(rect[0], rect[1], rect[2], rect[3]);
    }

    private static void writeSize(int[] rect) {
        AnalyzeEMFFile.writeSize(rect[0], rect[1]);
    }

    private static void writeRect(int x1, int y1, int x2, int y2) {
        AnalyzeEMFFile.writePoint(x1, y1);
        AnalyzeEMFFile.writePoint(x2, y1);
        AnalyzeEMFFile.writePoint(x2, y2);
        AnalyzeEMFFile.writePoint(x1, y2);
        AnalyzeEMFFile.writePoint(x1, y1);
    }

    private static void writeSize(int w, int h) {
        System.out.println("\t" + w + "\t" + h);
    }

    private static void writePoint(int x, int y) {
        System.out.println("\t" + x + "\t" + y);
    }

    private static int[] readRectangle(InputStream is) throws IOException {
        int[] rect = new int[4];
        int i = 0;
        while (i < 4) {
            rect[i] = AnalyzeEMFFile.readWordValue(is);
            ++i;
        }
        return rect;
    }

    private static int[] readRectL(InputStream is) throws IOException {
        int[] rect = new int[4];
        int i = 0;
        while (i < 4) {
            rect[i] = AnalyzeEMFFile.readLongValue(is);
            ++i;
        }
        return rect;
    }

    private static int[] readSizeL(InputStream is) throws IOException {
        int[] rect = new int[4];
        int i = 0;
        while (i < 2) {
            rect[i] = AnalyzeEMFFile.readLongValue(is);
            ++i;
        }
        return rect;
    }

    private static void readByteArray(String title, int count, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        AnalyzeEMFFile.readByteArray(count, is);
        System.out.println();
    }

    private static void readByteArray(int count, InputStream is) throws IOException {
        int i = 0;
        while (i < count) {
            if (i > 0) {
                System.out.print(",");
            }
            int value = AnalyzeEMFFile.readByteValue(is);
            System.out.print(value);
            ++i;
        }
    }

    private static int readLongValue(InputStream is) throws IOException {
        int value = (int)((long)AnalyzeEMFFile.readCardValue(is) + 65536L * (long)AnalyzeEMFFile.readCardValue(is));
        return value;
    }

    private static int readWordValue(InputStream is) throws IOException {
        int value = AnalyzeEMFFile.readCardValue(is);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    private static int readCardValue(InputStream is) throws IOException {
        int value = AnalyzeEMFFile.readByteValue(is) + 256 * AnalyzeEMFFile.readByteValue(is);
        return value;
    }

    private static int readByteValue(InputStream is) throws IOException {
        int value = is.read();
        return value;
    }

    private static int readWordValue(String title, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        int value = AnalyzeEMFFile.readWordValue(is);
        System.out.print(value);
        System.out.println();
        return value;
    }

    private static int readCardValue(String title, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        int value = AnalyzeEMFFile.readCardValue(is);
        System.out.print(value);
        System.out.println();
        return value;
    }

    private static int read4ByteValue(String title, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        int value = AnalyzeEMFFile.readLongValue(is);
        System.out.print(value);
        System.out.println();
        return value;
    }

    private static String bytesToBin(byte[] bytes) {
        String s = "";
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            s = String.valueOf(s) + String.format("%8s", Integer.toBinaryString(b & 0xFF)).replace(' ', '0');
            ++i;
        }
        return s;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    private static InputStream readSubData(InputStream is) throws IOException {
        byte[] data = AnalyzeEMFFile.flush(is);
        ByteArrayInputStream subData = new ByteArrayInputStream(data);
        return subData;
    }

    private static byte[] flush(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int i = is.read();
        while (i != -1) {
            os.write(i);
            i = is.read();
        }
        is.close();
        byte[] data = os.toByteArray();
        os.close();
        return data;
    }
}

